package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.MillisecondDateTime
import scala.jdk.CollectionConverters._
final case class ModifySnapshotTierResponse(
    snapshotId: Optional[String] = Optional.Absent,
    tieringStartTime: Optional[MillisecondDateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifySnapshotTierResponse = {
    import ModifySnapshotTierResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifySnapshotTierResponse
      .builder()
      .optionallyWith(snapshotId.map(value => value: java.lang.String))(
        _.snapshotId
      )
      .optionallyWith(
        tieringStartTime.map(value =>
          MillisecondDateTime.unwrap(value): Instant
        )
      )(_.tieringStartTime)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifySnapshotTierResponse.ReadOnly =
    zio.aws.ec2.model.ModifySnapshotTierResponse.wrap(buildAwsValue())
}
object ModifySnapshotTierResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifySnapshotTierResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifySnapshotTierResponse =
      zio.aws.ec2.model.ModifySnapshotTierResponse(
        snapshotId.map(value => value),
        tieringStartTime.map(value => value)
      )
    def snapshotId: Optional[String]
    def tieringStartTime: Optional[MillisecondDateTime]
    def getSnapshotId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getTieringStartTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("tieringStartTime", tieringStartTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifySnapshotTierResponse
  ) extends zio.aws.ec2.model.ModifySnapshotTierResponse.ReadOnly {
    override val snapshotId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotId())
      .map(value => value: String)
    override val tieringStartTime: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tieringStartTime())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifySnapshotTierResponse
  ): zio.aws.ec2.model.ModifySnapshotTierResponse.ReadOnly = new Wrapper(impl)
}
