package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{DateTime, Integer, CapacityReservationId}
import scala.jdk.CollectionConverters._
final case class ModifyCapacityReservationRequest(
    capacityReservationId: CapacityReservationId,
    instanceCount: Optional[Integer] = Optional.Absent,
    endDate: Optional[DateTime] = Optional.Absent,
    endDateType: Optional[zio.aws.ec2.model.EndDateType] = Optional.Absent,
    accept: Optional[Boolean] = Optional.Absent,
    additionalInfo: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyCapacityReservationRequest = {
    import ModifyCapacityReservationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyCapacityReservationRequest
      .builder()
      .capacityReservationId(
        CapacityReservationId.unwrap(capacityReservationId): java.lang.String
      )
      .optionallyWith(instanceCount.map(value => value: java.lang.Integer))(
        _.instanceCount
      )
      .optionallyWith(endDate.map(value => DateTime.unwrap(value): Instant))(
        _.endDate
      )
      .optionallyWith(endDateType.map(value => value.unwrap))(_.endDateType)
      .optionallyWith(accept.map(value => value: java.lang.Boolean))(_.accept)
      .optionallyWith(additionalInfo.map(value => value: java.lang.String))(
        _.additionalInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyCapacityReservationRequest.ReadOnly =
    zio.aws.ec2.model.ModifyCapacityReservationRequest.wrap(buildAwsValue())
}
object ModifyCapacityReservationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyCapacityReservationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyCapacityReservationRequest =
      zio.aws.ec2.model.ModifyCapacityReservationRequest(
        capacityReservationId,
        instanceCount.map(value => value),
        endDate.map(value => value),
        endDateType.map(value => value),
        accept.map(value => value),
        additionalInfo.map(value => value)
      )
    def capacityReservationId: CapacityReservationId
    def instanceCount: Optional[Integer]
    def endDate: Optional[DateTime]
    def endDateType: Optional[zio.aws.ec2.model.EndDateType]
    def accept: Optional[Boolean]
    def additionalInfo: Optional[String]
    def getCapacityReservationId: ZIO[Any, Nothing, CapacityReservationId] =
      ZIO.succeed(capacityReservationId)
    def getInstanceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("instanceCount", instanceCount)
    def getEndDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("endDate", endDate)
    def getEndDateType: ZIO[Any, AwsError, zio.aws.ec2.model.EndDateType] =
      AwsError.unwrapOptionField("endDateType", endDateType)
    def getAccept: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("accept", accept)
    def getAdditionalInfo: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("additionalInfo", additionalInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyCapacityReservationRequest
  ) extends zio.aws.ec2.model.ModifyCapacityReservationRequest.ReadOnly {
    override val capacityReservationId: CapacityReservationId =
      zio.aws.ec2.model.primitives
        .CapacityReservationId(impl.capacityReservationId())
    override val instanceCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceCount())
      .map(value => value: Integer)
    override val endDate: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.endDate())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val endDateType: Optional[zio.aws.ec2.model.EndDateType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endDateType())
        .map(value => zio.aws.ec2.model.EndDateType.wrap(value))
    override val accept: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.accept())
      .map(value => value: Boolean)
    override val additionalInfo: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalInfo())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyCapacityReservationRequest
  ): zio.aws.ec2.model.ModifyCapacityReservationRequest.ReadOnly = new Wrapper(
    impl
  )
}
