package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, ResourceArn, PrefixListResourceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ManagedPrefixList(
    prefixListId: Optional[PrefixListResourceId] = Optional.Absent,
    addressFamily: Optional[String] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.PrefixListState] = Optional.Absent,
    stateMessage: Optional[String] = Optional.Absent,
    prefixListArn: Optional[ResourceArn] = Optional.Absent,
    prefixListName: Optional[String] = Optional.Absent,
    maxEntries: Optional[Integer] = Optional.Absent,
    version: Optional[Long] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent,
    ownerId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ManagedPrefixList = {
    import ManagedPrefixList.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ManagedPrefixList
      .builder()
      .optionallyWith(
        prefixListId.map(value =>
          PrefixListResourceId.unwrap(value): java.lang.String
        )
      )(_.prefixListId)
      .optionallyWith(addressFamily.map(value => value: java.lang.String))(
        _.addressFamily
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(stateMessage.map(value => value: java.lang.String))(
        _.stateMessage
      )
      .optionallyWith(
        prefixListArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.prefixListArn)
      .optionallyWith(prefixListName.map(value => value: java.lang.String))(
        _.prefixListName
      )
      .optionallyWith(maxEntries.map(value => value: java.lang.Integer))(
        _.maxEntries
      )
      .optionallyWith(version.map(value => value: java.lang.Long))(_.version)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ManagedPrefixList.ReadOnly =
    zio.aws.ec2.model.ManagedPrefixList.wrap(buildAwsValue())
}
object ManagedPrefixList {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ManagedPrefixList
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ManagedPrefixList =
      zio.aws.ec2.model.ManagedPrefixList(
        prefixListId.map(value => value),
        addressFamily.map(value => value),
        state.map(value => value),
        stateMessage.map(value => value),
        prefixListArn.map(value => value),
        prefixListName.map(value => value),
        maxEntries.map(value => value),
        version.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ownerId.map(value => value)
      )
    def prefixListId: Optional[PrefixListResourceId]
    def addressFamily: Optional[String]
    def state: Optional[zio.aws.ec2.model.PrefixListState]
    def stateMessage: Optional[String]
    def prefixListArn: Optional[ResourceArn]
    def prefixListName: Optional[String]
    def maxEntries: Optional[Integer]
    def version: Optional[Long]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def ownerId: Optional[String]
    def getPrefixListId: ZIO[Any, AwsError, PrefixListResourceId] =
      AwsError.unwrapOptionField("prefixListId", prefixListId)
    def getAddressFamily: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("addressFamily", addressFamily)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.PrefixListState] =
      AwsError.unwrapOptionField("state", state)
    def getStateMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stateMessage", stateMessage)
    def getPrefixListArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("prefixListArn", prefixListArn)
    def getPrefixListName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("prefixListName", prefixListName)
    def getMaxEntries: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxEntries", maxEntries)
    def getVersion: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("version", version)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ManagedPrefixList
  ) extends zio.aws.ec2.model.ManagedPrefixList.ReadOnly {
    override val prefixListId: Optional[PrefixListResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.prefixListId())
        .map(value => zio.aws.ec2.model.primitives.PrefixListResourceId(value))
    override val addressFamily: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.addressFamily())
      .map(value => value: String)
    override val state: Optional[zio.aws.ec2.model.PrefixListState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.PrefixListState.wrap(value))
    override val stateMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.stateMessage())
      .map(value => value: String)
    override val prefixListArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.prefixListArn())
      .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
    override val prefixListName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.prefixListName())
      .map(value => value: String)
    override val maxEntries: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxEntries())
      .map(value => value: Integer)
    override val version: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: Long)
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ManagedPrefixList
  ): zio.aws.ec2.model.ManagedPrefixList.ReadOnly = new Wrapper(impl)
}
