package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.SubnetId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LaunchTemplateOverrides(
    instanceType: Optional[zio.aws.ec2.model.InstanceType] = Optional.Absent,
    spotPrice: Optional[String] = Optional.Absent,
    subnetId: Optional[SubnetId] = Optional.Absent,
    availabilityZone: Optional[String] = Optional.Absent,
    weightedCapacity: Optional[Double] = Optional.Absent,
    priority: Optional[Double] = Optional.Absent,
    instanceRequirements: Optional[zio.aws.ec2.model.InstanceRequirements] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LaunchTemplateOverrides = {
    import LaunchTemplateOverrides.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LaunchTemplateOverrides
      .builder()
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(spotPrice.map(value => value: java.lang.String))(
        _.spotPrice
      )
      .optionallyWith(
        subnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(weightedCapacity.map(value => value: java.lang.Double))(
        _.weightedCapacity
      )
      .optionallyWith(priority.map(value => value: java.lang.Double))(
        _.priority
      )
      .optionallyWith(instanceRequirements.map(value => value.buildAwsValue()))(
        _.instanceRequirements
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.LaunchTemplateOverrides.ReadOnly =
    zio.aws.ec2.model.LaunchTemplateOverrides.wrap(buildAwsValue())
}
object LaunchTemplateOverrides {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LaunchTemplateOverrides
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.LaunchTemplateOverrides =
      zio.aws.ec2.model.LaunchTemplateOverrides(
        instanceType.map(value => value),
        spotPrice.map(value => value),
        subnetId.map(value => value),
        availabilityZone.map(value => value),
        weightedCapacity.map(value => value),
        priority.map(value => value),
        instanceRequirements.map(value => value.asEditable)
      )
    def instanceType: Optional[zio.aws.ec2.model.InstanceType]
    def spotPrice: Optional[String]
    def subnetId: Optional[SubnetId]
    def availabilityZone: Optional[String]
    def weightedCapacity: Optional[Double]
    def priority: Optional[Double]
    def instanceRequirements
        : Optional[zio.aws.ec2.model.InstanceRequirements.ReadOnly]
    def getInstanceType: ZIO[Any, AwsError, zio.aws.ec2.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getSpotPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("spotPrice", spotPrice)
    def getSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getWeightedCapacity: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("weightedCapacity", weightedCapacity)
    def getPriority: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("priority", priority)
    def getInstanceRequirements
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceRequirements.ReadOnly] =
      AwsError.unwrapOptionField("instanceRequirements", instanceRequirements)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateOverrides
  ) extends zio.aws.ec2.model.LaunchTemplateOverrides.ReadOnly {
    override val instanceType: Optional[zio.aws.ec2.model.InstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value => zio.aws.ec2.model.InstanceType.wrap(value))
    override val spotPrice: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.spotPrice())
      .map(value => value: String)
    override val subnetId: Optional[SubnetId] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => zio.aws.ec2.model.primitives.SubnetId(value))
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val weightedCapacity: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.weightedCapacity())
      .map(value => value: Double)
    override val priority: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.priority())
      .map(value => value: Double)
    override val instanceRequirements
        : Optional[zio.aws.ec2.model.InstanceRequirements.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceRequirements())
        .map(value => zio.aws.ec2.model.InstanceRequirements.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateOverrides
  ): zio.aws.ec2.model.LaunchTemplateOverrides.ReadOnly = new Wrapper(impl)
}
