package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait IpamPoolPublicIpSource {
  def unwrap: software.amazon.awssdk.services.ec2.model.IpamPoolPublicIpSource
}
object IpamPoolPublicIpSource {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.IpamPoolPublicIpSource
  ): zio.aws.ec2.model.IpamPoolPublicIpSource = value match {
    case software.amazon.awssdk.services.ec2.model.IpamPoolPublicIpSource.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.IpamPoolPublicIpSource.AMAZON =>
      val r = amazon
      r
    case software.amazon.awssdk.services.ec2.model.IpamPoolPublicIpSource.BYOIP =>
      val r = byoip
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.IpamPoolPublicIpSource {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamPoolPublicIpSource =
      software.amazon.awssdk.services.ec2.model.IpamPoolPublicIpSource.UNKNOWN_TO_SDK_VERSION
  }
  case object amazon extends zio.aws.ec2.model.IpamPoolPublicIpSource {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamPoolPublicIpSource =
      software.amazon.awssdk.services.ec2.model.IpamPoolPublicIpSource.AMAZON
  }
  case object byoip extends zio.aws.ec2.model.IpamPoolPublicIpSource {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamPoolPublicIpSource =
      software.amazon.awssdk.services.ec2.model.IpamPoolPublicIpSource.BYOIP
  }
}
