package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  VpnGatewayId,
  CustomerGatewayId,
  TransitGatewayId,
  VpnConnectionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetVpnTunnelReplacementStatusResponse(
    vpnConnectionId: Optional[VpnConnectionId] = Optional.Absent,
    transitGatewayId: Optional[TransitGatewayId] = Optional.Absent,
    customerGatewayId: Optional[CustomerGatewayId] = Optional.Absent,
    vpnGatewayId: Optional[VpnGatewayId] = Optional.Absent,
    vpnTunnelOutsideIpAddress: Optional[String] = Optional.Absent,
    maintenanceDetails: Optional[zio.aws.ec2.model.MaintenanceDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetVpnTunnelReplacementStatusResponse = {
    import GetVpnTunnelReplacementStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetVpnTunnelReplacementStatusResponse
      .builder()
      .optionallyWith(
        vpnConnectionId.map(value =>
          VpnConnectionId.unwrap(value): java.lang.String
        )
      )(_.vpnConnectionId)
      .optionallyWith(
        transitGatewayId.map(value =>
          TransitGatewayId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayId)
      .optionallyWith(
        customerGatewayId.map(value =>
          CustomerGatewayId.unwrap(value): java.lang.String
        )
      )(_.customerGatewayId)
      .optionallyWith(
        vpnGatewayId.map(value => VpnGatewayId.unwrap(value): java.lang.String)
      )(_.vpnGatewayId)
      .optionallyWith(
        vpnTunnelOutsideIpAddress.map(value => value: java.lang.String)
      )(_.vpnTunnelOutsideIpAddress)
      .optionallyWith(maintenanceDetails.map(value => value.buildAwsValue()))(
        _.maintenanceDetails
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetVpnTunnelReplacementStatusResponse.ReadOnly =
    zio.aws.ec2.model.GetVpnTunnelReplacementStatusResponse
      .wrap(buildAwsValue())
}
object GetVpnTunnelReplacementStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetVpnTunnelReplacementStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetVpnTunnelReplacementStatusResponse =
      zio.aws.ec2.model.GetVpnTunnelReplacementStatusResponse(
        vpnConnectionId.map(value => value),
        transitGatewayId.map(value => value),
        customerGatewayId.map(value => value),
        vpnGatewayId.map(value => value),
        vpnTunnelOutsideIpAddress.map(value => value),
        maintenanceDetails.map(value => value.asEditable)
      )
    def vpnConnectionId: Optional[VpnConnectionId]
    def transitGatewayId: Optional[TransitGatewayId]
    def customerGatewayId: Optional[CustomerGatewayId]
    def vpnGatewayId: Optional[VpnGatewayId]
    def vpnTunnelOutsideIpAddress: Optional[String]
    def maintenanceDetails
        : Optional[zio.aws.ec2.model.MaintenanceDetails.ReadOnly]
    def getVpnConnectionId: ZIO[Any, AwsError, VpnConnectionId] =
      AwsError.unwrapOptionField("vpnConnectionId", vpnConnectionId)
    def getTransitGatewayId: ZIO[Any, AwsError, TransitGatewayId] =
      AwsError.unwrapOptionField("transitGatewayId", transitGatewayId)
    def getCustomerGatewayId: ZIO[Any, AwsError, CustomerGatewayId] =
      AwsError.unwrapOptionField("customerGatewayId", customerGatewayId)
    def getVpnGatewayId: ZIO[Any, AwsError, VpnGatewayId] =
      AwsError.unwrapOptionField("vpnGatewayId", vpnGatewayId)
    def getVpnTunnelOutsideIpAddress: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("vpnTunnelOutsideIpAddress", vpnTunnelOutsideIpAddress)
    def getMaintenanceDetails
        : ZIO[Any, AwsError, zio.aws.ec2.model.MaintenanceDetails.ReadOnly] =
      AwsError.unwrapOptionField("maintenanceDetails", maintenanceDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetVpnTunnelReplacementStatusResponse
  ) extends zio.aws.ec2.model.GetVpnTunnelReplacementStatusResponse.ReadOnly {
    override val vpnConnectionId: Optional[VpnConnectionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpnConnectionId())
        .map(value => zio.aws.ec2.model.primitives.VpnConnectionId(value))
    override val transitGatewayId: Optional[TransitGatewayId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayId())
        .map(value => zio.aws.ec2.model.primitives.TransitGatewayId(value))
    override val customerGatewayId: Optional[CustomerGatewayId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customerGatewayId())
        .map(value => zio.aws.ec2.model.primitives.CustomerGatewayId(value))
    override val vpnGatewayId: Optional[VpnGatewayId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpnGatewayId())
      .map(value => zio.aws.ec2.model.primitives.VpnGatewayId(value))
    override val vpnTunnelOutsideIpAddress: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpnTunnelOutsideIpAddress())
        .map(value => value: String)
    override val maintenanceDetails
        : Optional[zio.aws.ec2.model.MaintenanceDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maintenanceDetails())
        .map(value => zio.aws.ec2.model.MaintenanceDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetVpnTunnelReplacementStatusResponse
  ): zio.aws.ec2.model.GetVpnTunnelReplacementStatusResponse.ReadOnly =
    new Wrapper(impl)
}
