package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpnConnectionDeviceSampleConfiguration
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetVpnConnectionDeviceSampleConfigurationResponse(
    vpnConnectionDeviceSampleConfiguration: Optional[
      VpnConnectionDeviceSampleConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceSampleConfigurationResponse = {
    import GetVpnConnectionDeviceSampleConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceSampleConfigurationResponse
      .builder()
      .optionallyWith(
        vpnConnectionDeviceSampleConfiguration.map(value =>
          VpnConnectionDeviceSampleConfiguration.unwrap(value): java.lang.String
        )
      )(_.vpnConnectionDeviceSampleConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetVpnConnectionDeviceSampleConfigurationResponse.ReadOnly =
    zio.aws.ec2.model.GetVpnConnectionDeviceSampleConfigurationResponse
      .wrap(buildAwsValue())
}
object GetVpnConnectionDeviceSampleConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceSampleConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.GetVpnConnectionDeviceSampleConfigurationResponse =
      zio.aws.ec2.model.GetVpnConnectionDeviceSampleConfigurationResponse(
        vpnConnectionDeviceSampleConfiguration.map(value => value)
      )
    def vpnConnectionDeviceSampleConfiguration
        : Optional[VpnConnectionDeviceSampleConfiguration]
    def getVpnConnectionDeviceSampleConfiguration
        : ZIO[Any, AwsError, VpnConnectionDeviceSampleConfiguration] =
      AwsError.unwrapOptionField(
        "vpnConnectionDeviceSampleConfiguration",
        vpnConnectionDeviceSampleConfiguration
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceSampleConfigurationResponse
  ) extends zio.aws.ec2.model.GetVpnConnectionDeviceSampleConfigurationResponse.ReadOnly {
    override val vpnConnectionDeviceSampleConfiguration
        : Optional[VpnConnectionDeviceSampleConfiguration] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpnConnectionDeviceSampleConfiguration())
        .map(value =>
          zio.aws.ec2.model.primitives
            .VpnConnectionDeviceSampleConfiguration(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceSampleConfigurationResponse
  ): zio.aws.ec2.model.GetVpnConnectionDeviceSampleConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
