package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.DateTime
import scala.jdk.CollectionConverters._
final case class GetReservedInstancesExchangeQuoteResponse(
    currencyCode: Optional[String] = Optional.Absent,
    isValidExchange: Optional[Boolean] = Optional.Absent,
    outputReservedInstancesWillExpireAt: Optional[DateTime] = Optional.Absent,
    paymentDue: Optional[String] = Optional.Absent,
    reservedInstanceValueRollup: Optional[zio.aws.ec2.model.ReservationValue] =
      Optional.Absent,
    reservedInstanceValueSet: Optional[
      Iterable[zio.aws.ec2.model.ReservedInstanceReservationValue]
    ] = Optional.Absent,
    targetConfigurationValueRollup: Optional[
      zio.aws.ec2.model.ReservationValue
    ] = Optional.Absent,
    targetConfigurationValueSet: Optional[
      Iterable[zio.aws.ec2.model.TargetReservationValue]
    ] = Optional.Absent,
    validationFailureReason: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetReservedInstancesExchangeQuoteResponse = {
    import GetReservedInstancesExchangeQuoteResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetReservedInstancesExchangeQuoteResponse
      .builder()
      .optionallyWith(currencyCode.map(value => value: java.lang.String))(
        _.currencyCode
      )
      .optionallyWith(isValidExchange.map(value => value: java.lang.Boolean))(
        _.isValidExchange
      )
      .optionallyWith(
        outputReservedInstancesWillExpireAt.map(value =>
          DateTime.unwrap(value): Instant
        )
      )(_.outputReservedInstancesWillExpireAt)
      .optionallyWith(paymentDue.map(value => value: java.lang.String))(
        _.paymentDue
      )
      .optionallyWith(
        reservedInstanceValueRollup.map(value => value.buildAwsValue())
      )(_.reservedInstanceValueRollup)
      .optionallyWith(
        reservedInstanceValueSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reservedInstanceValueSet)
      .optionallyWith(
        targetConfigurationValueRollup.map(value => value.buildAwsValue())
      )(_.targetConfigurationValueRollup)
      .optionallyWith(
        targetConfigurationValueSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetConfigurationValueSet)
      .optionallyWith(
        validationFailureReason.map(value => value: java.lang.String)
      )(_.validationFailureReason)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetReservedInstancesExchangeQuoteResponse.ReadOnly =
    zio.aws.ec2.model.GetReservedInstancesExchangeQuoteResponse
      .wrap(buildAwsValue())
}
object GetReservedInstancesExchangeQuoteResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetReservedInstancesExchangeQuoteResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.GetReservedInstancesExchangeQuoteResponse =
      zio.aws.ec2.model.GetReservedInstancesExchangeQuoteResponse(
        currencyCode.map(value => value),
        isValidExchange.map(value => value),
        outputReservedInstancesWillExpireAt.map(value => value),
        paymentDue.map(value => value),
        reservedInstanceValueRollup.map(value => value.asEditable),
        reservedInstanceValueSet.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        targetConfigurationValueRollup.map(value => value.asEditable),
        targetConfigurationValueSet.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        validationFailureReason.map(value => value)
      )
    def currencyCode: Optional[String]
    def isValidExchange: Optional[Boolean]
    def outputReservedInstancesWillExpireAt: Optional[DateTime]
    def paymentDue: Optional[String]
    def reservedInstanceValueRollup
        : Optional[zio.aws.ec2.model.ReservationValue.ReadOnly]
    def reservedInstanceValueSet: Optional[
      List[zio.aws.ec2.model.ReservedInstanceReservationValue.ReadOnly]
    ]
    def targetConfigurationValueRollup
        : Optional[zio.aws.ec2.model.ReservationValue.ReadOnly]
    def targetConfigurationValueSet
        : Optional[List[zio.aws.ec2.model.TargetReservationValue.ReadOnly]]
    def validationFailureReason: Optional[String]
    def getCurrencyCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("currencyCode", currencyCode)
    def getIsValidExchange: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isValidExchange", isValidExchange)
    def getOutputReservedInstancesWillExpireAt: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField(
        "outputReservedInstancesWillExpireAt",
        outputReservedInstancesWillExpireAt
      )
    def getPaymentDue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("paymentDue", paymentDue)
    def getReservedInstanceValueRollup
        : ZIO[Any, AwsError, zio.aws.ec2.model.ReservationValue.ReadOnly] =
      AwsError.unwrapOptionField(
        "reservedInstanceValueRollup",
        reservedInstanceValueRollup
      )
    def getReservedInstanceValueSet: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ReservedInstanceReservationValue.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "reservedInstanceValueSet",
      reservedInstanceValueSet
    )
    def getTargetConfigurationValueRollup
        : ZIO[Any, AwsError, zio.aws.ec2.model.ReservationValue.ReadOnly] =
      AwsError.unwrapOptionField(
        "targetConfigurationValueRollup",
        targetConfigurationValueRollup
      )
    def getTargetConfigurationValueSet: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TargetReservationValue.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "targetConfigurationValueSet",
      targetConfigurationValueSet
    )
    def getValidationFailureReason: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("validationFailureReason", validationFailureReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetReservedInstancesExchangeQuoteResponse
  ) extends zio.aws.ec2.model.GetReservedInstancesExchangeQuoteResponse.ReadOnly {
    override val currencyCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.currencyCode())
      .map(value => value: String)
    override val isValidExchange: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isValidExchange())
      .map(value => value: Boolean)
    override val outputReservedInstancesWillExpireAt: Optional[DateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputReservedInstancesWillExpireAt())
        .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val paymentDue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.paymentDue())
      .map(value => value: String)
    override val reservedInstanceValueRollup
        : Optional[zio.aws.ec2.model.ReservationValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedInstanceValueRollup())
        .map(value => zio.aws.ec2.model.ReservationValue.wrap(value))
    override val reservedInstanceValueSet: Optional[
      List[zio.aws.ec2.model.ReservedInstanceReservationValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.reservedInstanceValueSet())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ReservedInstanceReservationValue.wrap(item)
        }.toList
      )
    override val targetConfigurationValueRollup
        : Optional[zio.aws.ec2.model.ReservationValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetConfigurationValueRollup())
        .map(value => zio.aws.ec2.model.ReservationValue.wrap(value))
    override val targetConfigurationValueSet
        : Optional[List[zio.aws.ec2.model.TargetReservationValue.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetConfigurationValueSet())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TargetReservationValue.wrap(item)
          }.toList
        )
    override val validationFailureReason: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validationFailureReason())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetReservedInstancesExchangeQuoteResponse
  ): zio.aws.ec2.model.GetReservedInstancesExchangeQuoteResponse.ReadOnly =
    new Wrapper(impl)
}
