package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  MillisecondDateTime,
  CapacityReservationId,
  IntegerWithConstraints,
  DoubleWithConstraints,
  Integer
}
import scala.jdk.CollectionConverters._
final case class FleetCapacityReservation(
    capacityReservationId: Optional[CapacityReservationId] = Optional.Absent,
    availabilityZoneId: Optional[String] = Optional.Absent,
    instanceType: Optional[zio.aws.ec2.model.InstanceType] = Optional.Absent,
    instancePlatform: Optional[
      zio.aws.ec2.model.CapacityReservationInstancePlatform
    ] = Optional.Absent,
    availabilityZone: Optional[String] = Optional.Absent,
    totalInstanceCount: Optional[Integer] = Optional.Absent,
    fulfilledCapacity: Optional[Double] = Optional.Absent,
    ebsOptimized: Optional[Boolean] = Optional.Absent,
    createDate: Optional[MillisecondDateTime] = Optional.Absent,
    weight: Optional[DoubleWithConstraints] = Optional.Absent,
    priority: Optional[IntegerWithConstraints] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.FleetCapacityReservation = {
    import FleetCapacityReservation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.FleetCapacityReservation
      .builder()
      .optionallyWith(
        capacityReservationId.map(value =>
          CapacityReservationId.unwrap(value): java.lang.String
        )
      )(_.capacityReservationId)
      .optionallyWith(availabilityZoneId.map(value => value: java.lang.String))(
        _.availabilityZoneId
      )
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(instancePlatform.map(value => value.unwrap))(
        _.instancePlatform
      )
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(
        totalInstanceCount.map(value => value: java.lang.Integer)
      )(_.totalInstanceCount)
      .optionallyWith(fulfilledCapacity.map(value => value: java.lang.Double))(
        _.fulfilledCapacity
      )
      .optionallyWith(ebsOptimized.map(value => value: java.lang.Boolean))(
        _.ebsOptimized
      )
      .optionallyWith(
        createDate.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.createDate)
      .optionallyWith(
        weight.map(value =>
          DoubleWithConstraints.unwrap(value): java.lang.Double
        )
      )(_.weight)
      .optionallyWith(
        priority.map(value =>
          IntegerWithConstraints.unwrap(value): java.lang.Integer
        )
      )(_.priority)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.FleetCapacityReservation.ReadOnly =
    zio.aws.ec2.model.FleetCapacityReservation.wrap(buildAwsValue())
}
object FleetCapacityReservation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.FleetCapacityReservation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.FleetCapacityReservation =
      zio.aws.ec2.model.FleetCapacityReservation(
        capacityReservationId.map(value => value),
        availabilityZoneId.map(value => value),
        instanceType.map(value => value),
        instancePlatform.map(value => value),
        availabilityZone.map(value => value),
        totalInstanceCount.map(value => value),
        fulfilledCapacity.map(value => value),
        ebsOptimized.map(value => value),
        createDate.map(value => value),
        weight.map(value => value),
        priority.map(value => value)
      )
    def capacityReservationId: Optional[CapacityReservationId]
    def availabilityZoneId: Optional[String]
    def instanceType: Optional[zio.aws.ec2.model.InstanceType]
    def instancePlatform
        : Optional[zio.aws.ec2.model.CapacityReservationInstancePlatform]
    def availabilityZone: Optional[String]
    def totalInstanceCount: Optional[Integer]
    def fulfilledCapacity: Optional[Double]
    def ebsOptimized: Optional[Boolean]
    def createDate: Optional[MillisecondDateTime]
    def weight: Optional[DoubleWithConstraints]
    def priority: Optional[IntegerWithConstraints]
    def getCapacityReservationId: ZIO[Any, AwsError, CapacityReservationId] =
      AwsError.unwrapOptionField("capacityReservationId", capacityReservationId)
    def getAvailabilityZoneId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZoneId", availabilityZoneId)
    def getInstanceType: ZIO[Any, AwsError, zio.aws.ec2.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getInstancePlatform: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.CapacityReservationInstancePlatform
    ] = AwsError.unwrapOptionField("instancePlatform", instancePlatform)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getTotalInstanceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalInstanceCount", totalInstanceCount)
    def getFulfilledCapacity: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("fulfilledCapacity", fulfilledCapacity)
    def getEbsOptimized: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ebsOptimized", ebsOptimized)
    def getCreateDate: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getWeight: ZIO[Any, AwsError, DoubleWithConstraints] =
      AwsError.unwrapOptionField("weight", weight)
    def getPriority: ZIO[Any, AwsError, IntegerWithConstraints] =
      AwsError.unwrapOptionField("priority", priority)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.FleetCapacityReservation
  ) extends zio.aws.ec2.model.FleetCapacityReservation.ReadOnly {
    override val capacityReservationId: Optional[CapacityReservationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacityReservationId())
        .map(value => zio.aws.ec2.model.primitives.CapacityReservationId(value))
    override val availabilityZoneId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZoneId())
      .map(value => value: String)
    override val instanceType: Optional[zio.aws.ec2.model.InstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value => zio.aws.ec2.model.InstanceType.wrap(value))
    override val instancePlatform
        : Optional[zio.aws.ec2.model.CapacityReservationInstancePlatform] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instancePlatform())
        .map(value =>
          zio.aws.ec2.model.CapacityReservationInstancePlatform.wrap(value)
        )
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val totalInstanceCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.totalInstanceCount())
      .map(value => value: Integer)
    override val fulfilledCapacity: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.fulfilledCapacity())
      .map(value => value: Double)
    override val ebsOptimized: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.ebsOptimized())
      .map(value => value: Boolean)
    override val createDate: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createDate())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val weight: Optional[DoubleWithConstraints] = zio.aws.core.internal
      .optionalFromNullable(impl.weight())
      .map(value => zio.aws.ec2.model.primitives.DoubleWithConstraints(value))
    override val priority: Optional[IntegerWithConstraints] =
      zio.aws.core.internal
        .optionalFromNullable(impl.priority())
        .map(value =>
          zio.aws.ec2.model.primitives.IntegerWithConstraints(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.FleetCapacityReservation
  ): zio.aws.ec2.model.FleetCapacityReservation.ReadOnly = new Wrapper(impl)
}
