package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait DiskType {
  def unwrap: software.amazon.awssdk.services.ec2.model.DiskType
}
object DiskType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.DiskType
  ): zio.aws.ec2.model.DiskType = value match {
    case software.amazon.awssdk.services.ec2.model.DiskType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.DiskType.HDD =>
      val r = hdd
      r
    case software.amazon.awssdk.services.ec2.model.DiskType.SSD =>
      val r = ssd
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.DiskType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.DiskType =
      software.amazon.awssdk.services.ec2.model.DiskType.UNKNOWN_TO_SDK_VERSION
  }
  case object hdd extends zio.aws.ec2.model.DiskType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.DiskType =
      software.amazon.awssdk.services.ec2.model.DiskType.HDD
  }
  case object ssd extends zio.aws.ec2.model.DiskType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.DiskType =
      software.amazon.awssdk.services.ec2.model.DiskType.SSD
  }
}
