package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.IpamResourceDiscoveryAssociationId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisassociateIpamResourceDiscoveryRequest(
    ipamResourceDiscoveryAssociationId: IpamResourceDiscoveryAssociationId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisassociateIpamResourceDiscoveryRequest = {
    import DisassociateIpamResourceDiscoveryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisassociateIpamResourceDiscoveryRequest
      .builder()
      .ipamResourceDiscoveryAssociationId(
        IpamResourceDiscoveryAssociationId.unwrap(
          ipamResourceDiscoveryAssociationId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DisassociateIpamResourceDiscoveryRequest.ReadOnly =
    zio.aws.ec2.model.DisassociateIpamResourceDiscoveryRequest
      .wrap(buildAwsValue())
}
object DisassociateIpamResourceDiscoveryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisassociateIpamResourceDiscoveryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DisassociateIpamResourceDiscoveryRequest =
      zio.aws.ec2.model.DisassociateIpamResourceDiscoveryRequest(
        ipamResourceDiscoveryAssociationId
      )
    def ipamResourceDiscoveryAssociationId: IpamResourceDiscoveryAssociationId
    def getIpamResourceDiscoveryAssociationId
        : ZIO[Any, Nothing, IpamResourceDiscoveryAssociationId] =
      ZIO.succeed(ipamResourceDiscoveryAssociationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateIpamResourceDiscoveryRequest
  ) extends zio.aws.ec2.model.DisassociateIpamResourceDiscoveryRequest.ReadOnly {
    override val ipamResourceDiscoveryAssociationId
        : IpamResourceDiscoveryAssociationId =
      zio.aws.ec2.model.primitives.IpamResourceDiscoveryAssociationId(
        impl.ipamResourceDiscoveryAssociationId()
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateIpamResourceDiscoveryRequest
  ): zio.aws.ec2.model.DisassociateIpamResourceDiscoveryRequest.ReadOnly =
    new Wrapper(impl)
}
