package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  DescribeClientVpnConnectionsMaxResults,
  NextToken,
  ClientVpnEndpointId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeClientVpnConnectionsRequest(
    clientVpnEndpointId: ClientVpnEndpointId,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[DescribeClientVpnConnectionsMaxResults] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeClientVpnConnectionsRequest = {
    import DescribeClientVpnConnectionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeClientVpnConnectionsRequest
      .builder()
      .clientVpnEndpointId(
        ClientVpnEndpointId.unwrap(clientVpnEndpointId): java.lang.String
      )
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          DescribeClientVpnConnectionsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeClientVpnConnectionsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeClientVpnConnectionsRequest.wrap(buildAwsValue())
}
object DescribeClientVpnConnectionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeClientVpnConnectionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeClientVpnConnectionsRequest =
      zio.aws.ec2.model.DescribeClientVpnConnectionsRequest(
        clientVpnEndpointId,
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def clientVpnEndpointId: ClientVpnEndpointId
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[DescribeClientVpnConnectionsMaxResults]
    def getClientVpnEndpointId: ZIO[Any, Nothing, ClientVpnEndpointId] =
      ZIO.succeed(clientVpnEndpointId)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults
        : ZIO[Any, AwsError, DescribeClientVpnConnectionsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeClientVpnConnectionsRequest
  ) extends zio.aws.ec2.model.DescribeClientVpnConnectionsRequest.ReadOnly {
    override val clientVpnEndpointId: ClientVpnEndpointId =
      zio.aws.ec2.model.primitives
        .ClientVpnEndpointId(impl.clientVpnEndpointId())
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
    override val maxResults: Optional[DescribeClientVpnConnectionsMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives
            .DescribeClientVpnConnectionsMaxResults(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeClientVpnConnectionsRequest
  ): zio.aws.ec2.model.DescribeClientVpnConnectionsRequest.ReadOnly =
    new Wrapper(impl)
}
