package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  DescribeAddressTransfersMaxResults,
  AllocationId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeAddressTransfersRequest(
    allocationIds: Optional[Iterable[AllocationId]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[DescribeAddressTransfersMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeAddressTransfersRequest = {
    import DescribeAddressTransfersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeAddressTransfersRequest
      .builder()
      .optionallyWith(
        allocationIds.map(value =>
          value.map { item =>
            AllocationId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.allocationIds)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value =>
          DescribeAddressTransfersMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeAddressTransfersRequest.ReadOnly =
    zio.aws.ec2.model.DescribeAddressTransfersRequest.wrap(buildAwsValue())
}
object DescribeAddressTransfersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeAddressTransfersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeAddressTransfersRequest =
      zio.aws.ec2.model.DescribeAddressTransfersRequest(
        allocationIds.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def allocationIds: Optional[List[AllocationId]]
    def nextToken: Optional[String]
    def maxResults: Optional[DescribeAddressTransfersMaxResults]
    def getAllocationIds: ZIO[Any, AwsError, List[AllocationId]] =
      AwsError.unwrapOptionField("allocationIds", allocationIds)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, DescribeAddressTransfersMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeAddressTransfersRequest
  ) extends zio.aws.ec2.model.DescribeAddressTransfersRequest.ReadOnly {
    override val allocationIds: Optional[List[AllocationId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allocationIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.AllocationId(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[DescribeAddressTransfersMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives.DescribeAddressTransfersMaxResults(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeAddressTransfersRequest
  ): zio.aws.ec2.model.DescribeAddressTransfersRequest.ReadOnly = new Wrapper(
    impl
  )
}
