package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait DeleteFleetErrorCode {
  def unwrap: software.amazon.awssdk.services.ec2.model.DeleteFleetErrorCode
}
object DeleteFleetErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.DeleteFleetErrorCode
  ): zio.aws.ec2.model.DeleteFleetErrorCode = value match {
    case software.amazon.awssdk.services.ec2.model.DeleteFleetErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.DeleteFleetErrorCode.FLEET_ID_DOES_NOT_EXIST =>
      val r = fleetIdDoesNotExist
      r
    case software.amazon.awssdk.services.ec2.model.DeleteFleetErrorCode.FLEET_ID_MALFORMED =>
      val r = fleetIdMalformed
      r
    case software.amazon.awssdk.services.ec2.model.DeleteFleetErrorCode.FLEET_NOT_IN_DELETABLE_STATE =>
      val r = fleetNotInDeletableState
      r
    case software.amazon.awssdk.services.ec2.model.DeleteFleetErrorCode.UNEXPECTED_ERROR =>
      val r = unexpectedError
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.DeleteFleetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DeleteFleetErrorCode =
      software.amazon.awssdk.services.ec2.model.DeleteFleetErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object fleetIdDoesNotExist
      extends zio.aws.ec2.model.DeleteFleetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DeleteFleetErrorCode =
      software.amazon.awssdk.services.ec2.model.DeleteFleetErrorCode.FLEET_ID_DOES_NOT_EXIST
  }
  case object fleetIdMalformed extends zio.aws.ec2.model.DeleteFleetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DeleteFleetErrorCode =
      software.amazon.awssdk.services.ec2.model.DeleteFleetErrorCode.FLEET_ID_MALFORMED
  }
  case object fleetNotInDeletableState
      extends zio.aws.ec2.model.DeleteFleetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DeleteFleetErrorCode =
      software.amazon.awssdk.services.ec2.model.DeleteFleetErrorCode.FLEET_NOT_IN_DELETABLE_STATE
  }
  case object unexpectedError extends zio.aws.ec2.model.DeleteFleetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DeleteFleetErrorCode =
      software.amazon.awssdk.services.ec2.model.DeleteFleetErrorCode.UNEXPECTED_ERROR
  }
}
