package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateInternetGatewayResponse(
    internetGateway: Optional[zio.aws.ec2.model.InternetGateway] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateInternetGatewayResponse = {
    import CreateInternetGatewayResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateInternetGatewayResponse
      .builder()
      .optionallyWith(internetGateway.map(value => value.buildAwsValue()))(
        _.internetGateway
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateInternetGatewayResponse.ReadOnly =
    zio.aws.ec2.model.CreateInternetGatewayResponse.wrap(buildAwsValue())
}
object CreateInternetGatewayResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateInternetGatewayResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateInternetGatewayResponse =
      zio.aws.ec2.model.CreateInternetGatewayResponse(
        internetGateway.map(value => value.asEditable)
      )
    def internetGateway: Optional[zio.aws.ec2.model.InternetGateway.ReadOnly]
    def getInternetGateway
        : ZIO[Any, AwsError, zio.aws.ec2.model.InternetGateway.ReadOnly] =
      AwsError.unwrapOptionField("internetGateway", internetGateway)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateInternetGatewayResponse
  ) extends zio.aws.ec2.model.CreateInternetGatewayResponse.ReadOnly {
    override val internetGateway
        : Optional[zio.aws.ec2.model.InternetGateway.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.internetGateway())
        .map(value => zio.aws.ec2.model.InternetGateway.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateInternetGatewayResponse
  ): zio.aws.ec2.model.CreateInternetGatewayResponse.ReadOnly = new Wrapper(
    impl
  )
}
