package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CancelImportTaskResponse(
    importTaskId: Optional[String] = Optional.Absent,
    previousState: Optional[String] = Optional.Absent,
    state: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CancelImportTaskResponse = {
    import CancelImportTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CancelImportTaskResponse
      .builder()
      .optionallyWith(importTaskId.map(value => value: java.lang.String))(
        _.importTaskId
      )
      .optionallyWith(previousState.map(value => value: java.lang.String))(
        _.previousState
      )
      .optionallyWith(state.map(value => value: java.lang.String))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CancelImportTaskResponse.ReadOnly =
    zio.aws.ec2.model.CancelImportTaskResponse.wrap(buildAwsValue())
}
object CancelImportTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CancelImportTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CancelImportTaskResponse =
      zio.aws.ec2.model.CancelImportTaskResponse(
        importTaskId.map(value => value),
        previousState.map(value => value),
        state.map(value => value)
      )
    def importTaskId: Optional[String]
    def previousState: Optional[String]
    def state: Optional[String]
    def getImportTaskId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("importTaskId", importTaskId)
    def getPreviousState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("previousState", previousState)
    def getState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CancelImportTaskResponse
  ) extends zio.aws.ec2.model.CancelImportTaskResponse.ReadOnly {
    override val importTaskId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.importTaskId())
      .map(value => value: String)
    override val previousState: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.previousState())
      .map(value => value: String)
    override val state: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.state())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CancelImportTaskResponse
  ): zio.aws.ec2.model.CancelImportTaskResponse.ReadOnly = new Wrapper(impl)
}
