package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AttachmentEnaSrdSpecification(
    enaSrdEnabled: Optional[Boolean] = Optional.Absent,
    enaSrdUdpSpecification: Optional[
      zio.aws.ec2.model.AttachmentEnaSrdUdpSpecification
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AttachmentEnaSrdSpecification = {
    import AttachmentEnaSrdSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AttachmentEnaSrdSpecification
      .builder()
      .optionallyWith(enaSrdEnabled.map(value => value: java.lang.Boolean))(
        _.enaSrdEnabled
      )
      .optionallyWith(
        enaSrdUdpSpecification.map(value => value.buildAwsValue())
      )(_.enaSrdUdpSpecification)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AttachmentEnaSrdSpecification.ReadOnly =
    zio.aws.ec2.model.AttachmentEnaSrdSpecification.wrap(buildAwsValue())
}
object AttachmentEnaSrdSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AttachmentEnaSrdSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AttachmentEnaSrdSpecification =
      zio.aws.ec2.model.AttachmentEnaSrdSpecification(
        enaSrdEnabled.map(value => value),
        enaSrdUdpSpecification.map(value => value.asEditable)
      )
    def enaSrdEnabled: Optional[Boolean]
    def enaSrdUdpSpecification
        : Optional[zio.aws.ec2.model.AttachmentEnaSrdUdpSpecification.ReadOnly]
    def getEnaSrdEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enaSrdEnabled", enaSrdEnabled)
    def getEnaSrdUdpSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.AttachmentEnaSrdUdpSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "enaSrdUdpSpecification",
      enaSrdUdpSpecification
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AttachmentEnaSrdSpecification
  ) extends zio.aws.ec2.model.AttachmentEnaSrdSpecification.ReadOnly {
    override val enaSrdEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enaSrdEnabled())
      .map(value => value: Boolean)
    override val enaSrdUdpSpecification: Optional[
      zio.aws.ec2.model.AttachmentEnaSrdUdpSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.enaSrdUdpSpecification())
      .map(value =>
        zio.aws.ec2.model.AttachmentEnaSrdUdpSpecification.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AttachmentEnaSrdSpecification
  ): zio.aws.ec2.model.AttachmentEnaSrdSpecification.ReadOnly = new Wrapper(
    impl
  )
}
