package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  VerifiedAccessTrustProviderId,
  VerifiedAccessInstanceId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AttachVerifiedAccessTrustProviderRequest(
    verifiedAccessInstanceId: VerifiedAccessInstanceId,
    verifiedAccessTrustProviderId: VerifiedAccessTrustProviderId,
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AttachVerifiedAccessTrustProviderRequest = {
    import AttachVerifiedAccessTrustProviderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AttachVerifiedAccessTrustProviderRequest
      .builder()
      .verifiedAccessInstanceId(
        VerifiedAccessInstanceId.unwrap(
          verifiedAccessInstanceId
        ): java.lang.String
      )
      .verifiedAccessTrustProviderId(
        VerifiedAccessTrustProviderId.unwrap(
          verifiedAccessTrustProviderId
        ): java.lang.String
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.AttachVerifiedAccessTrustProviderRequest.ReadOnly =
    zio.aws.ec2.model.AttachVerifiedAccessTrustProviderRequest
      .wrap(buildAwsValue())
}
object AttachVerifiedAccessTrustProviderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AttachVerifiedAccessTrustProviderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AttachVerifiedAccessTrustProviderRequest =
      zio.aws.ec2.model.AttachVerifiedAccessTrustProviderRequest(
        verifiedAccessInstanceId,
        verifiedAccessTrustProviderId,
        clientToken.map(value => value)
      )
    def verifiedAccessInstanceId: VerifiedAccessInstanceId
    def verifiedAccessTrustProviderId: VerifiedAccessTrustProviderId
    def clientToken: Optional[String]
    def getVerifiedAccessInstanceId
        : ZIO[Any, Nothing, VerifiedAccessInstanceId] =
      ZIO.succeed(verifiedAccessInstanceId)
    def getVerifiedAccessTrustProviderId
        : ZIO[Any, Nothing, VerifiedAccessTrustProviderId] =
      ZIO.succeed(verifiedAccessTrustProviderId)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AttachVerifiedAccessTrustProviderRequest
  ) extends zio.aws.ec2.model.AttachVerifiedAccessTrustProviderRequest.ReadOnly {
    override val verifiedAccessInstanceId: VerifiedAccessInstanceId =
      zio.aws.ec2.model.primitives
        .VerifiedAccessInstanceId(impl.verifiedAccessInstanceId())
    override val verifiedAccessTrustProviderId: VerifiedAccessTrustProviderId =
      zio.aws.ec2.model.primitives
        .VerifiedAccessTrustProviderId(impl.verifiedAccessTrustProviderId())
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AttachVerifiedAccessTrustProviderRequest
  ): zio.aws.ec2.model.AttachVerifiedAccessTrustProviderRequest.ReadOnly =
    new Wrapper(impl)
}
