package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociateRouteTableResponse(
    associationId: Optional[String] = Optional.Absent,
    associationState: Optional[zio.aws.ec2.model.RouteTableAssociationState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AssociateRouteTableResponse = {
    import AssociateRouteTableResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AssociateRouteTableResponse
      .builder()
      .optionallyWith(associationId.map(value => value: java.lang.String))(
        _.associationId
      )
      .optionallyWith(associationState.map(value => value.buildAwsValue()))(
        _.associationState
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AssociateRouteTableResponse.ReadOnly =
    zio.aws.ec2.model.AssociateRouteTableResponse.wrap(buildAwsValue())
}
object AssociateRouteTableResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AssociateRouteTableResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AssociateRouteTableResponse =
      zio.aws.ec2.model.AssociateRouteTableResponse(
        associationId.map(value => value),
        associationState.map(value => value.asEditable)
      )
    def associationId: Optional[String]
    def associationState
        : Optional[zio.aws.ec2.model.RouteTableAssociationState.ReadOnly]
    def getAssociationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getAssociationState: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.RouteTableAssociationState.ReadOnly
    ] = AwsError.unwrapOptionField("associationState", associationState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AssociateRouteTableResponse
  ) extends zio.aws.ec2.model.AssociateRouteTableResponse.ReadOnly {
    override val associationId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.associationId())
      .map(value => value: String)
    override val associationState
        : Optional[zio.aws.ec2.model.RouteTableAssociationState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationState())
        .map(value => zio.aws.ec2.model.RouteTableAssociationState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AssociateRouteTableResponse
  ): zio.aws.ec2.model.AssociateRouteTableResponse.ReadOnly = new Wrapper(impl)
}
