package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{IpamResourceDiscoveryId, IpamId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociateIpamResourceDiscoveryRequest(
    ipamId: IpamId,
    ipamResourceDiscoveryId: IpamResourceDiscoveryId,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent,
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AssociateIpamResourceDiscoveryRequest = {
    import AssociateIpamResourceDiscoveryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AssociateIpamResourceDiscoveryRequest
      .builder()
      .ipamId(IpamId.unwrap(ipamId): java.lang.String)
      .ipamResourceDiscoveryId(
        IpamResourceDiscoveryId.unwrap(
          ipamResourceDiscoveryId
        ): java.lang.String
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.AssociateIpamResourceDiscoveryRequest.ReadOnly =
    zio.aws.ec2.model.AssociateIpamResourceDiscoveryRequest
      .wrap(buildAwsValue())
}
object AssociateIpamResourceDiscoveryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AssociateIpamResourceDiscoveryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AssociateIpamResourceDiscoveryRequest =
      zio.aws.ec2.model.AssociateIpamResourceDiscoveryRequest(
        ipamId,
        ipamResourceDiscoveryId,
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientToken.map(value => value)
      )
    def ipamId: IpamId
    def ipamResourceDiscoveryId: IpamResourceDiscoveryId
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def clientToken: Optional[String]
    def getIpamId: ZIO[Any, Nothing, IpamId] = ZIO.succeed(ipamId)
    def getIpamResourceDiscoveryId: ZIO[Any, Nothing, IpamResourceDiscoveryId] =
      ZIO.succeed(ipamResourceDiscoveryId)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AssociateIpamResourceDiscoveryRequest
  ) extends zio.aws.ec2.model.AssociateIpamResourceDiscoveryRequest.ReadOnly {
    override val ipamId: IpamId =
      zio.aws.ec2.model.primitives.IpamId(impl.ipamId())
    override val ipamResourceDiscoveryId: IpamResourceDiscoveryId =
      zio.aws.ec2.model.primitives
        .IpamResourceDiscoveryId(impl.ipamResourceDiscoveryId())
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AssociateIpamResourceDiscoveryRequest
  ): zio.aws.ec2.model.AssociateIpamResourceDiscoveryRequest.ReadOnly =
    new Wrapper(impl)
}
