package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{AllocationId, PublicIpAddress}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AddressAttribute(
    publicIp: Optional[PublicIpAddress] = Optional.Absent,
    allocationId: Optional[AllocationId] = Optional.Absent,
    ptrRecord: Optional[String] = Optional.Absent,
    ptrRecordUpdate: Optional[zio.aws.ec2.model.PtrUpdateStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AddressAttribute = {
    import AddressAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AddressAttribute
      .builder()
      .optionallyWith(
        publicIp.map(value => PublicIpAddress.unwrap(value): java.lang.String)
      )(_.publicIp)
      .optionallyWith(
        allocationId.map(value => AllocationId.unwrap(value): java.lang.String)
      )(_.allocationId)
      .optionallyWith(ptrRecord.map(value => value: java.lang.String))(
        _.ptrRecord
      )
      .optionallyWith(ptrRecordUpdate.map(value => value.buildAwsValue()))(
        _.ptrRecordUpdate
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AddressAttribute.ReadOnly =
    zio.aws.ec2.model.AddressAttribute.wrap(buildAwsValue())
}
object AddressAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AddressAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AddressAttribute =
      zio.aws.ec2.model.AddressAttribute(
        publicIp.map(value => value),
        allocationId.map(value => value),
        ptrRecord.map(value => value),
        ptrRecordUpdate.map(value => value.asEditable)
      )
    def publicIp: Optional[PublicIpAddress]
    def allocationId: Optional[AllocationId]
    def ptrRecord: Optional[String]
    def ptrRecordUpdate: Optional[zio.aws.ec2.model.PtrUpdateStatus.ReadOnly]
    def getPublicIp: ZIO[Any, AwsError, PublicIpAddress] =
      AwsError.unwrapOptionField("publicIp", publicIp)
    def getAllocationId: ZIO[Any, AwsError, AllocationId] =
      AwsError.unwrapOptionField("allocationId", allocationId)
    def getPtrRecord: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ptrRecord", ptrRecord)
    def getPtrRecordUpdate
        : ZIO[Any, AwsError, zio.aws.ec2.model.PtrUpdateStatus.ReadOnly] =
      AwsError.unwrapOptionField("ptrRecordUpdate", ptrRecordUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AddressAttribute
  ) extends zio.aws.ec2.model.AddressAttribute.ReadOnly {
    override val publicIp: Optional[PublicIpAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.publicIp())
      .map(value => zio.aws.ec2.model.primitives.PublicIpAddress(value))
    override val allocationId: Optional[AllocationId] = zio.aws.core.internal
      .optionalFromNullable(impl.allocationId())
      .map(value => zio.aws.ec2.model.primitives.AllocationId(value))
    override val ptrRecord: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ptrRecord())
      .map(value => value: String)
    override val ptrRecordUpdate
        : Optional[zio.aws.ec2.model.PtrUpdateStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ptrRecordUpdate())
        .map(value => zio.aws.ec2.model.PtrUpdateStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AddressAttribute
  ): zio.aws.ec2.model.AddressAttribute.ReadOnly = new Wrapper(impl)
}
