package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait AcceleratorType {
  def unwrap: software.amazon.awssdk.services.ec2.model.AcceleratorType
}
object AcceleratorType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.AcceleratorType
  ): zio.aws.ec2.model.AcceleratorType = value match {
    case software.amazon.awssdk.services.ec2.model.AcceleratorType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.AcceleratorType.GPU =>
      val r = gpu
      r
    case software.amazon.awssdk.services.ec2.model.AcceleratorType.FPGA =>
      val r = fpga
      r
    case software.amazon.awssdk.services.ec2.model.AcceleratorType.INFERENCE =>
      val r = inference
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.AcceleratorType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AcceleratorType =
      software.amazon.awssdk.services.ec2.model.AcceleratorType.UNKNOWN_TO_SDK_VERSION
  }
  case object gpu extends zio.aws.ec2.model.AcceleratorType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AcceleratorType =
      software.amazon.awssdk.services.ec2.model.AcceleratorType.GPU
  }
  case object fpga extends zio.aws.ec2.model.AcceleratorType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AcceleratorType =
      software.amazon.awssdk.services.ec2.model.AcceleratorType.FPGA
  }
  case object inference extends zio.aws.ec2.model.AcceleratorType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AcceleratorType =
      software.amazon.awssdk.services.ec2.model.AcceleratorType.INFERENCE
  }
}
