package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait SpreadLevel {
  def unwrap: software.amazon.awssdk.services.ec2.model.SpreadLevel
}
object SpreadLevel {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.SpreadLevel
  ): zio.aws.ec2.model.SpreadLevel = value match {
    case software.amazon.awssdk.services.ec2.model.SpreadLevel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.SpreadLevel.HOST =>
      val r = host
      r
    case software.amazon.awssdk.services.ec2.model.SpreadLevel.RACK =>
      val r = rack
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.SpreadLevel {
    override def unwrap: software.amazon.awssdk.services.ec2.model.SpreadLevel =
      software.amazon.awssdk.services.ec2.model.SpreadLevel.UNKNOWN_TO_SDK_VERSION
  }
  case object host extends zio.aws.ec2.model.SpreadLevel {
    override def unwrap: software.amazon.awssdk.services.ec2.model.SpreadLevel =
      software.amazon.awssdk.services.ec2.model.SpreadLevel.HOST
  }
  case object rack extends zio.aws.ec2.model.SpreadLevel {
    override def unwrap: software.amazon.awssdk.services.ec2.model.SpreadLevel =
      software.amazon.awssdk.services.ec2.model.SpreadLevel.RACK
  }
}
