package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Blob
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class S3Storage(
    awsAccessKeyId: Optional[String] = Optional.Absent,
    bucket: Optional[String] = Optional.Absent,
    prefix: Optional[String] = Optional.Absent,
    uploadPolicy: Optional[Blob] = Optional.Absent,
    uploadPolicySignature: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.S3Storage = {
    import S3Storage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.S3Storage
      .builder()
      .optionallyWith(awsAccessKeyId.map(value => value: java.lang.String))(
        _.awsAccessKeyId
      )
      .optionallyWith(bucket.map(value => value: java.lang.String))(_.bucket)
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .optionallyWith(
        uploadPolicy.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.uploadPolicy)
      .optionallyWith(
        uploadPolicySignature.map(value => value: java.lang.String)
      )(_.uploadPolicySignature)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.S3Storage.ReadOnly =
    zio.aws.ec2.model.S3Storage.wrap(buildAwsValue())
}
object S3Storage {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.S3Storage] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.S3Storage = zio.aws.ec2.model.S3Storage(
      awsAccessKeyId.map(value => value),
      bucket.map(value => value),
      prefix.map(value => value),
      uploadPolicy.map(value => value),
      uploadPolicySignature.map(value => value)
    )
    def awsAccessKeyId: Optional[String]
    def bucket: Optional[String]
    def prefix: Optional[String]
    def uploadPolicy: Optional[Blob]
    def uploadPolicySignature: Optional[String]
    def getAwsAccessKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("awsAccessKeyId", awsAccessKeyId)
    def getBucket: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getPrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getUploadPolicy: ZIO[Any, AwsError, Blob] =
      AwsError.unwrapOptionField("uploadPolicy", uploadPolicy)
    def getUploadPolicySignature: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("uploadPolicySignature", uploadPolicySignature)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.S3Storage
  ) extends zio.aws.ec2.model.S3Storage.ReadOnly {
    override val awsAccessKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.awsAccessKeyId())
      .map(value => value: String)
    override val bucket: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.bucket())
      .map(value => value: String)
    override val prefix: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => value: String)
    override val uploadPolicy: Optional[Blob] = zio.aws.core.internal
      .optionalFromNullable(impl.uploadPolicy())
      .map(value =>
        zio.aws.ec2.model.primitives
          .Blob(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val uploadPolicySignature: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.uploadPolicySignature())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.S3Storage
  ): zio.aws.ec2.model.S3Storage.ReadOnly = new Wrapper(impl)
}
