package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  NetworkInterfaceId,
  TransitGatewayMulticastDomainId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RegisterTransitGatewayMulticastGroupSourcesRequest(
    transitGatewayMulticastDomainId: TransitGatewayMulticastDomainId,
    groupIpAddress: Optional[String] = Optional.Absent,
    networkInterfaceIds: Iterable[NetworkInterfaceId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupSourcesRequest = {
    import RegisterTransitGatewayMulticastGroupSourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupSourcesRequest
      .builder()
      .transitGatewayMulticastDomainId(
        TransitGatewayMulticastDomainId.unwrap(
          transitGatewayMulticastDomainId
        ): java.lang.String
      )
      .optionallyWith(groupIpAddress.map(value => value: java.lang.String))(
        _.groupIpAddress
      )
      .networkInterfaceIds(networkInterfaceIds.map { item =>
        NetworkInterfaceId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupSourcesRequest.ReadOnly =
    zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupSourcesRequest
      .wrap(buildAwsValue())
}
object RegisterTransitGatewayMulticastGroupSourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupSourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupSourcesRequest =
      zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupSourcesRequest(
        transitGatewayMulticastDomainId,
        groupIpAddress.map(value => value),
        networkInterfaceIds
      )
    def transitGatewayMulticastDomainId: TransitGatewayMulticastDomainId
    def groupIpAddress: Optional[String]
    def networkInterfaceIds: List[NetworkInterfaceId]
    def getTransitGatewayMulticastDomainId
        : ZIO[Any, Nothing, TransitGatewayMulticastDomainId] =
      ZIO.succeed(transitGatewayMulticastDomainId)
    def getGroupIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupIpAddress", groupIpAddress)
    def getNetworkInterfaceIds: ZIO[Any, Nothing, List[NetworkInterfaceId]] =
      ZIO.succeed(networkInterfaceIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupSourcesRequest
  ) extends zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupSourcesRequest.ReadOnly {
    override val transitGatewayMulticastDomainId
        : TransitGatewayMulticastDomainId = zio.aws.ec2.model.primitives
      .TransitGatewayMulticastDomainId(impl.transitGatewayMulticastDomainId())
    override val groupIpAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groupIpAddress())
      .map(value => value: String)
    override val networkInterfaceIds: List[NetworkInterfaceId] = impl
      .networkInterfaceIds()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.NetworkInterfaceId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupSourcesRequest
  ): zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupSourcesRequest.ReadOnly =
    new Wrapper(impl)
}
