package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait ProductCodeValues {
  def unwrap: software.amazon.awssdk.services.ec2.model.ProductCodeValues
}
object ProductCodeValues {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.ProductCodeValues
  ): zio.aws.ec2.model.ProductCodeValues = value match {
    case software.amazon.awssdk.services.ec2.model.ProductCodeValues.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.ProductCodeValues.DEVPAY =>
      val r = devpay
      r
    case software.amazon.awssdk.services.ec2.model.ProductCodeValues.MARKETPLACE =>
      val r = marketplace
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.ProductCodeValues {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ProductCodeValues =
      software.amazon.awssdk.services.ec2.model.ProductCodeValues.UNKNOWN_TO_SDK_VERSION
  }
  case object devpay extends zio.aws.ec2.model.ProductCodeValues {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ProductCodeValues =
      software.amazon.awssdk.services.ec2.model.ProductCodeValues.DEVPAY
  }
  case object marketplace extends zio.aws.ec2.model.ProductCodeValues {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ProductCodeValues =
      software.amazon.awssdk.services.ec2.model.ProductCodeValues.MARKETPLACE
  }
}
