package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, PreSharedKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyVpnTunnelOptionsSpecification(
    tunnelInsideCidr: Optional[String] = Optional.Absent,
    tunnelInsideIpv6Cidr: Optional[String] = Optional.Absent,
    preSharedKey: Optional[PreSharedKey] = Optional.Absent,
    phase1LifetimeSeconds: Optional[Integer] = Optional.Absent,
    phase2LifetimeSeconds: Optional[Integer] = Optional.Absent,
    rekeyMarginTimeSeconds: Optional[Integer] = Optional.Absent,
    rekeyFuzzPercentage: Optional[Integer] = Optional.Absent,
    replayWindowSize: Optional[Integer] = Optional.Absent,
    dpdTimeoutSeconds: Optional[Integer] = Optional.Absent,
    dpdTimeoutAction: Optional[String] = Optional.Absent,
    phase1EncryptionAlgorithms: Optional[
      Iterable[zio.aws.ec2.model.Phase1EncryptionAlgorithmsRequestListValue]
    ] = Optional.Absent,
    phase2EncryptionAlgorithms: Optional[
      Iterable[zio.aws.ec2.model.Phase2EncryptionAlgorithmsRequestListValue]
    ] = Optional.Absent,
    phase1IntegrityAlgorithms: Optional[
      Iterable[zio.aws.ec2.model.Phase1IntegrityAlgorithmsRequestListValue]
    ] = Optional.Absent,
    phase2IntegrityAlgorithms: Optional[
      Iterable[zio.aws.ec2.model.Phase2IntegrityAlgorithmsRequestListValue]
    ] = Optional.Absent,
    phase1DHGroupNumbers: Optional[
      Iterable[zio.aws.ec2.model.Phase1DHGroupNumbersRequestListValue]
    ] = Optional.Absent,
    phase2DHGroupNumbers: Optional[
      Iterable[zio.aws.ec2.model.Phase2DHGroupNumbersRequestListValue]
    ] = Optional.Absent,
    ikeVersions: Optional[
      Iterable[zio.aws.ec2.model.IKEVersionsRequestListValue]
    ] = Optional.Absent,
    startupAction: Optional[String] = Optional.Absent,
    logOptions: Optional[zio.aws.ec2.model.VpnTunnelLogOptionsSpecification] =
      Optional.Absent,
    enableTunnelLifecycleControl: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelOptionsSpecification = {
    import ModifyVpnTunnelOptionsSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelOptionsSpecification
      .builder()
      .optionallyWith(tunnelInsideCidr.map(value => value: java.lang.String))(
        _.tunnelInsideCidr
      )
      .optionallyWith(
        tunnelInsideIpv6Cidr.map(value => value: java.lang.String)
      )(_.tunnelInsideIpv6Cidr)
      .optionallyWith(
        preSharedKey.map(value => PreSharedKey.unwrap(value): java.lang.String)
      )(_.preSharedKey)
      .optionallyWith(
        phase1LifetimeSeconds.map(value => value: java.lang.Integer)
      )(_.phase1LifetimeSeconds)
      .optionallyWith(
        phase2LifetimeSeconds.map(value => value: java.lang.Integer)
      )(_.phase2LifetimeSeconds)
      .optionallyWith(
        rekeyMarginTimeSeconds.map(value => value: java.lang.Integer)
      )(_.rekeyMarginTimeSeconds)
      .optionallyWith(
        rekeyFuzzPercentage.map(value => value: java.lang.Integer)
      )(_.rekeyFuzzPercentage)
      .optionallyWith(replayWindowSize.map(value => value: java.lang.Integer))(
        _.replayWindowSize
      )
      .optionallyWith(dpdTimeoutSeconds.map(value => value: java.lang.Integer))(
        _.dpdTimeoutSeconds
      )
      .optionallyWith(dpdTimeoutAction.map(value => value: java.lang.String))(
        _.dpdTimeoutAction
      )
      .optionallyWith(
        phase1EncryptionAlgorithms.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.phase1EncryptionAlgorithms)
      .optionallyWith(
        phase2EncryptionAlgorithms.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.phase2EncryptionAlgorithms)
      .optionallyWith(
        phase1IntegrityAlgorithms.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.phase1IntegrityAlgorithms)
      .optionallyWith(
        phase2IntegrityAlgorithms.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.phase2IntegrityAlgorithms)
      .optionallyWith(
        phase1DHGroupNumbers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.phase1DHGroupNumbers)
      .optionallyWith(
        phase2DHGroupNumbers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.phase2DHGroupNumbers)
      .optionallyWith(
        ikeVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ikeVersions)
      .optionallyWith(startupAction.map(value => value: java.lang.String))(
        _.startupAction
      )
      .optionallyWith(logOptions.map(value => value.buildAwsValue()))(
        _.logOptions
      )
      .optionallyWith(
        enableTunnelLifecycleControl.map(value => value: java.lang.Boolean)
      )(_.enableTunnelLifecycleControl)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyVpnTunnelOptionsSpecification.ReadOnly =
    zio.aws.ec2.model.ModifyVpnTunnelOptionsSpecification.wrap(buildAwsValue())
}
object ModifyVpnTunnelOptionsSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelOptionsSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyVpnTunnelOptionsSpecification =
      zio.aws.ec2.model.ModifyVpnTunnelOptionsSpecification(
        tunnelInsideCidr.map(value => value),
        tunnelInsideIpv6Cidr.map(value => value),
        preSharedKey.map(value => value),
        phase1LifetimeSeconds.map(value => value),
        phase2LifetimeSeconds.map(value => value),
        rekeyMarginTimeSeconds.map(value => value),
        rekeyFuzzPercentage.map(value => value),
        replayWindowSize.map(value => value),
        dpdTimeoutSeconds.map(value => value),
        dpdTimeoutAction.map(value => value),
        phase1EncryptionAlgorithms.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        phase2EncryptionAlgorithms.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        phase1IntegrityAlgorithms.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        phase2IntegrityAlgorithms.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        phase1DHGroupNumbers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        phase2DHGroupNumbers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ikeVersions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        startupAction.map(value => value),
        logOptions.map(value => value.asEditable),
        enableTunnelLifecycleControl.map(value => value)
      )
    def tunnelInsideCidr: Optional[String]
    def tunnelInsideIpv6Cidr: Optional[String]
    def preSharedKey: Optional[PreSharedKey]
    def phase1LifetimeSeconds: Optional[Integer]
    def phase2LifetimeSeconds: Optional[Integer]
    def rekeyMarginTimeSeconds: Optional[Integer]
    def rekeyFuzzPercentage: Optional[Integer]
    def replayWindowSize: Optional[Integer]
    def dpdTimeoutSeconds: Optional[Integer]
    def dpdTimeoutAction: Optional[String]
    def phase1EncryptionAlgorithms: Optional[List[
      zio.aws.ec2.model.Phase1EncryptionAlgorithmsRequestListValue.ReadOnly
    ]]
    def phase2EncryptionAlgorithms: Optional[List[
      zio.aws.ec2.model.Phase2EncryptionAlgorithmsRequestListValue.ReadOnly
    ]]
    def phase1IntegrityAlgorithms: Optional[
      List[zio.aws.ec2.model.Phase1IntegrityAlgorithmsRequestListValue.ReadOnly]
    ]
    def phase2IntegrityAlgorithms: Optional[
      List[zio.aws.ec2.model.Phase2IntegrityAlgorithmsRequestListValue.ReadOnly]
    ]
    def phase1DHGroupNumbers: Optional[
      List[zio.aws.ec2.model.Phase1DHGroupNumbersRequestListValue.ReadOnly]
    ]
    def phase2DHGroupNumbers: Optional[
      List[zio.aws.ec2.model.Phase2DHGroupNumbersRequestListValue.ReadOnly]
    ]
    def ikeVersions
        : Optional[List[zio.aws.ec2.model.IKEVersionsRequestListValue.ReadOnly]]
    def startupAction: Optional[String]
    def logOptions
        : Optional[zio.aws.ec2.model.VpnTunnelLogOptionsSpecification.ReadOnly]
    def enableTunnelLifecycleControl: Optional[Boolean]
    def getTunnelInsideCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tunnelInsideCidr", tunnelInsideCidr)
    def getTunnelInsideIpv6Cidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tunnelInsideIpv6Cidr", tunnelInsideIpv6Cidr)
    def getPreSharedKey: ZIO[Any, AwsError, PreSharedKey] =
      AwsError.unwrapOptionField("preSharedKey", preSharedKey)
    def getPhase1LifetimeSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("phase1LifetimeSeconds", phase1LifetimeSeconds)
    def getPhase2LifetimeSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("phase2LifetimeSeconds", phase2LifetimeSeconds)
    def getRekeyMarginTimeSeconds: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("rekeyMarginTimeSeconds", rekeyMarginTimeSeconds)
    def getRekeyFuzzPercentage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("rekeyFuzzPercentage", rekeyFuzzPercentage)
    def getReplayWindowSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("replayWindowSize", replayWindowSize)
    def getDpdTimeoutSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("dpdTimeoutSeconds", dpdTimeoutSeconds)
    def getDpdTimeoutAction: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dpdTimeoutAction", dpdTimeoutAction)
    def getPhase1EncryptionAlgorithms: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.Phase1EncryptionAlgorithmsRequestListValue.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "phase1EncryptionAlgorithms",
      phase1EncryptionAlgorithms
    )
    def getPhase2EncryptionAlgorithms: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.Phase2EncryptionAlgorithmsRequestListValue.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "phase2EncryptionAlgorithms",
      phase2EncryptionAlgorithms
    )
    def getPhase1IntegrityAlgorithms: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.Phase1IntegrityAlgorithmsRequestListValue.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "phase1IntegrityAlgorithms",
      phase1IntegrityAlgorithms
    )
    def getPhase2IntegrityAlgorithms: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.Phase2IntegrityAlgorithmsRequestListValue.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "phase2IntegrityAlgorithms",
      phase2IntegrityAlgorithms
    )
    def getPhase1DHGroupNumbers: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.Phase1DHGroupNumbersRequestListValue.ReadOnly
    ]] =
      AwsError.unwrapOptionField("phase1DHGroupNumbers", phase1DHGroupNumbers)
    def getPhase2DHGroupNumbers: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.Phase2DHGroupNumbersRequestListValue.ReadOnly
    ]] =
      AwsError.unwrapOptionField("phase2DHGroupNumbers", phase2DHGroupNumbers)
    def getIkeVersions: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.IKEVersionsRequestListValue.ReadOnly
    ]] = AwsError.unwrapOptionField("ikeVersions", ikeVersions)
    def getStartupAction: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("startupAction", startupAction)
    def getLogOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VpnTunnelLogOptionsSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("logOptions", logOptions)
    def getEnableTunnelLifecycleControl: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "enableTunnelLifecycleControl",
        enableTunnelLifecycleControl
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelOptionsSpecification
  ) extends zio.aws.ec2.model.ModifyVpnTunnelOptionsSpecification.ReadOnly {
    override val tunnelInsideCidr: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.tunnelInsideCidr())
      .map(value => value: String)
    override val tunnelInsideIpv6Cidr: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.tunnelInsideIpv6Cidr())
      .map(value => value: String)
    override val preSharedKey: Optional[PreSharedKey] = zio.aws.core.internal
      .optionalFromNullable(impl.preSharedKey())
      .map(value => zio.aws.ec2.model.primitives.PreSharedKey(value))
    override val phase1LifetimeSeconds: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phase1LifetimeSeconds())
        .map(value => value: Integer)
    override val phase2LifetimeSeconds: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phase2LifetimeSeconds())
        .map(value => value: Integer)
    override val rekeyMarginTimeSeconds: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rekeyMarginTimeSeconds())
        .map(value => value: Integer)
    override val rekeyFuzzPercentage: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.rekeyFuzzPercentage())
      .map(value => value: Integer)
    override val replayWindowSize: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.replayWindowSize())
      .map(value => value: Integer)
    override val dpdTimeoutSeconds: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.dpdTimeoutSeconds())
      .map(value => value: Integer)
    override val dpdTimeoutAction: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dpdTimeoutAction())
      .map(value => value: String)
    override val phase1EncryptionAlgorithms: Optional[List[
      zio.aws.ec2.model.Phase1EncryptionAlgorithmsRequestListValue.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.phase1EncryptionAlgorithms())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Phase1EncryptionAlgorithmsRequestListValue
            .wrap(item)
        }.toList
      )
    override val phase2EncryptionAlgorithms: Optional[List[
      zio.aws.ec2.model.Phase2EncryptionAlgorithmsRequestListValue.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.phase2EncryptionAlgorithms())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Phase2EncryptionAlgorithmsRequestListValue
            .wrap(item)
        }.toList
      )
    override val phase1IntegrityAlgorithms: Optional[
      List[zio.aws.ec2.model.Phase1IntegrityAlgorithmsRequestListValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.phase1IntegrityAlgorithms())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Phase1IntegrityAlgorithmsRequestListValue.wrap(item)
        }.toList
      )
    override val phase2IntegrityAlgorithms: Optional[
      List[zio.aws.ec2.model.Phase2IntegrityAlgorithmsRequestListValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.phase2IntegrityAlgorithms())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Phase2IntegrityAlgorithmsRequestListValue.wrap(item)
        }.toList
      )
    override val phase1DHGroupNumbers: Optional[
      List[zio.aws.ec2.model.Phase1DHGroupNumbersRequestListValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.phase1DHGroupNumbers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Phase1DHGroupNumbersRequestListValue.wrap(item)
        }.toList
      )
    override val phase2DHGroupNumbers: Optional[
      List[zio.aws.ec2.model.Phase2DHGroupNumbersRequestListValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.phase2DHGroupNumbers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Phase2DHGroupNumbersRequestListValue.wrap(item)
        }.toList
      )
    override val ikeVersions: Optional[
      List[zio.aws.ec2.model.IKEVersionsRequestListValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ikeVersions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.IKEVersionsRequestListValue.wrap(item)
        }.toList
      )
    override val startupAction: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.startupAction())
      .map(value => value: String)
    override val logOptions: Optional[
      zio.aws.ec2.model.VpnTunnelLogOptionsSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.logOptions())
      .map(value =>
        zio.aws.ec2.model.VpnTunnelLogOptionsSpecification.wrap(value)
      )
    override val enableTunnelLifecycleControl: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableTunnelLifecycleControl())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelOptionsSpecification
  ): zio.aws.ec2.model.ModifyVpnTunnelOptionsSpecification.ReadOnly =
    new Wrapper(impl)
}
