package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyVpcEndpointServicePermissionsResponse(
    addedPrincipals: Optional[Iterable[zio.aws.ec2.model.AddedPrincipal]] =
      Optional.Absent,
    returnValue: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServicePermissionsResponse = {
    import ModifyVpcEndpointServicePermissionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServicePermissionsResponse
      .builder()
      .optionallyWith(
        addedPrincipals.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addedPrincipals)
      .optionallyWith(returnValue.map(value => value: java.lang.Boolean))(
        _.returnValue
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyVpcEndpointServicePermissionsResponse.ReadOnly =
    zio.aws.ec2.model.ModifyVpcEndpointServicePermissionsResponse
      .wrap(buildAwsValue())
}
object ModifyVpcEndpointServicePermissionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServicePermissionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.ModifyVpcEndpointServicePermissionsResponse =
      zio.aws.ec2.model.ModifyVpcEndpointServicePermissionsResponse(
        addedPrincipals.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        returnValue.map(value => value)
      )
    def addedPrincipals
        : Optional[List[zio.aws.ec2.model.AddedPrincipal.ReadOnly]]
    def returnValue: Optional[Boolean]
    def getAddedPrincipals
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.AddedPrincipal.ReadOnly]] =
      AwsError.unwrapOptionField("addedPrincipals", addedPrincipals)
    def getReturnValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("returnValue", returnValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServicePermissionsResponse
  ) extends zio.aws.ec2.model.ModifyVpcEndpointServicePermissionsResponse.ReadOnly {
    override val addedPrincipals
        : Optional[List[zio.aws.ec2.model.AddedPrincipal.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addedPrincipals())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.AddedPrincipal.wrap(item)
          }.toList
        )
    override val returnValue: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.returnValue())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServicePermissionsResponse
  ): zio.aws.ec2.model.ModifyVpcEndpointServicePermissionsResponse.ReadOnly =
    new Wrapper(impl)
}
