package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, CoipPoolId, SubnetId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifySubnetAttributeRequest(
    assignIpv6AddressOnCreation: Optional[
      zio.aws.ec2.model.AttributeBooleanValue
    ] = Optional.Absent,
    mapPublicIpOnLaunch: Optional[zio.aws.ec2.model.AttributeBooleanValue] =
      Optional.Absent,
    subnetId: SubnetId,
    mapCustomerOwnedIpOnLaunch: Optional[
      zio.aws.ec2.model.AttributeBooleanValue
    ] = Optional.Absent,
    customerOwnedIpv4Pool: Optional[CoipPoolId] = Optional.Absent,
    enableDns64: Optional[zio.aws.ec2.model.AttributeBooleanValue] =
      Optional.Absent,
    privateDnsHostnameTypeOnLaunch: Optional[zio.aws.ec2.model.HostnameType] =
      Optional.Absent,
    enableResourceNameDnsARecordOnLaunch: Optional[
      zio.aws.ec2.model.AttributeBooleanValue
    ] = Optional.Absent,
    enableResourceNameDnsAAAARecordOnLaunch: Optional[
      zio.aws.ec2.model.AttributeBooleanValue
    ] = Optional.Absent,
    enableLniAtDeviceIndex: Optional[Integer] = Optional.Absent,
    disableLniAtDeviceIndex: Optional[zio.aws.ec2.model.AttributeBooleanValue] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifySubnetAttributeRequest = {
    import ModifySubnetAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifySubnetAttributeRequest
      .builder()
      .optionallyWith(
        assignIpv6AddressOnCreation.map(value => value.buildAwsValue())
      )(_.assignIpv6AddressOnCreation)
      .optionallyWith(mapPublicIpOnLaunch.map(value => value.buildAwsValue()))(
        _.mapPublicIpOnLaunch
      )
      .subnetId(SubnetId.unwrap(subnetId): java.lang.String)
      .optionallyWith(
        mapCustomerOwnedIpOnLaunch.map(value => value.buildAwsValue())
      )(_.mapCustomerOwnedIpOnLaunch)
      .optionallyWith(
        customerOwnedIpv4Pool.map(value =>
          CoipPoolId.unwrap(value): java.lang.String
        )
      )(_.customerOwnedIpv4Pool)
      .optionallyWith(enableDns64.map(value => value.buildAwsValue()))(
        _.enableDns64
      )
      .optionallyWith(
        privateDnsHostnameTypeOnLaunch.map(value => value.unwrap)
      )(_.privateDnsHostnameTypeOnLaunch)
      .optionallyWith(
        enableResourceNameDnsARecordOnLaunch.map(value => value.buildAwsValue())
      )(_.enableResourceNameDnsARecordOnLaunch)
      .optionallyWith(
        enableResourceNameDnsAAAARecordOnLaunch.map(value =>
          value.buildAwsValue()
        )
      )(_.enableResourceNameDnsAAAARecordOnLaunch)
      .optionallyWith(
        enableLniAtDeviceIndex.map(value => value: java.lang.Integer)
      )(_.enableLniAtDeviceIndex)
      .optionallyWith(
        disableLniAtDeviceIndex.map(value => value.buildAwsValue())
      )(_.disableLniAtDeviceIndex)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifySubnetAttributeRequest.ReadOnly =
    zio.aws.ec2.model.ModifySubnetAttributeRequest.wrap(buildAwsValue())
}
object ModifySubnetAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifySubnetAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifySubnetAttributeRequest =
      zio.aws.ec2.model.ModifySubnetAttributeRequest(
        assignIpv6AddressOnCreation.map(value => value.asEditable),
        mapPublicIpOnLaunch.map(value => value.asEditable),
        subnetId,
        mapCustomerOwnedIpOnLaunch.map(value => value.asEditable),
        customerOwnedIpv4Pool.map(value => value),
        enableDns64.map(value => value.asEditable),
        privateDnsHostnameTypeOnLaunch.map(value => value),
        enableResourceNameDnsARecordOnLaunch.map(value => value.asEditable),
        enableResourceNameDnsAAAARecordOnLaunch.map(value => value.asEditable),
        enableLniAtDeviceIndex.map(value => value),
        disableLniAtDeviceIndex.map(value => value.asEditable)
      )
    def assignIpv6AddressOnCreation
        : Optional[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def mapPublicIpOnLaunch
        : Optional[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def subnetId: SubnetId
    def mapCustomerOwnedIpOnLaunch
        : Optional[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def customerOwnedIpv4Pool: Optional[CoipPoolId]
    def enableDns64: Optional[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def privateDnsHostnameTypeOnLaunch: Optional[zio.aws.ec2.model.HostnameType]
    def enableResourceNameDnsARecordOnLaunch
        : Optional[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def enableResourceNameDnsAAAARecordOnLaunch
        : Optional[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def enableLniAtDeviceIndex: Optional[Integer]
    def disableLniAtDeviceIndex
        : Optional[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def getAssignIpv6AddressOnCreation
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField(
        "assignIpv6AddressOnCreation",
        assignIpv6AddressOnCreation
      )
    def getMapPublicIpOnLaunch
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField("mapPublicIpOnLaunch", mapPublicIpOnLaunch)
    def getSubnetId: ZIO[Any, Nothing, SubnetId] = ZIO.succeed(subnetId)
    def getMapCustomerOwnedIpOnLaunch
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField(
        "mapCustomerOwnedIpOnLaunch",
        mapCustomerOwnedIpOnLaunch
      )
    def getCustomerOwnedIpv4Pool: ZIO[Any, AwsError, CoipPoolId] =
      AwsError.unwrapOptionField("customerOwnedIpv4Pool", customerOwnedIpv4Pool)
    def getEnableDns64
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField("enableDns64", enableDns64)
    def getPrivateDnsHostnameTypeOnLaunch
        : ZIO[Any, AwsError, zio.aws.ec2.model.HostnameType] =
      AwsError.unwrapOptionField(
        "privateDnsHostnameTypeOnLaunch",
        privateDnsHostnameTypeOnLaunch
      )
    def getEnableResourceNameDnsARecordOnLaunch
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField(
        "enableResourceNameDnsARecordOnLaunch",
        enableResourceNameDnsARecordOnLaunch
      )
    def getEnableResourceNameDnsAAAARecordOnLaunch
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField(
        "enableResourceNameDnsAAAARecordOnLaunch",
        enableResourceNameDnsAAAARecordOnLaunch
      )
    def getEnableLniAtDeviceIndex: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("enableLniAtDeviceIndex", enableLniAtDeviceIndex)
    def getDisableLniAtDeviceIndex
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField(
        "disableLniAtDeviceIndex",
        disableLniAtDeviceIndex
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifySubnetAttributeRequest
  ) extends zio.aws.ec2.model.ModifySubnetAttributeRequest.ReadOnly {
    override val assignIpv6AddressOnCreation
        : Optional[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assignIpv6AddressOnCreation())
        .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
    override val mapPublicIpOnLaunch
        : Optional[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mapPublicIpOnLaunch())
        .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
    override val subnetId: SubnetId =
      zio.aws.ec2.model.primitives.SubnetId(impl.subnetId())
    override val mapCustomerOwnedIpOnLaunch
        : Optional[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mapCustomerOwnedIpOnLaunch())
        .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
    override val customerOwnedIpv4Pool: Optional[CoipPoolId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customerOwnedIpv4Pool())
        .map(value => zio.aws.ec2.model.primitives.CoipPoolId(value))
    override val enableDns64
        : Optional[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableDns64())
        .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
    override val privateDnsHostnameTypeOnLaunch
        : Optional[zio.aws.ec2.model.HostnameType] = zio.aws.core.internal
      .optionalFromNullable(impl.privateDnsHostnameTypeOnLaunch())
      .map(value => zio.aws.ec2.model.HostnameType.wrap(value))
    override val enableResourceNameDnsARecordOnLaunch
        : Optional[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableResourceNameDnsARecordOnLaunch())
        .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
    override val enableResourceNameDnsAAAARecordOnLaunch
        : Optional[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableResourceNameDnsAAAARecordOnLaunch())
        .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
    override val enableLniAtDeviceIndex: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableLniAtDeviceIndex())
        .map(value => value: Integer)
    override val disableLniAtDeviceIndex
        : Optional[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disableLniAtDeviceIndex())
        .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifySubnetAttributeRequest
  ): zio.aws.ec2.model.ModifySubnetAttributeRequest.ReadOnly = new Wrapper(impl)
}
