package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.MillisecondDateTime
import scala.jdk.CollectionConverters._
final case class MaintenanceDetails(
    pendingMaintenance: Optional[String] = Optional.Absent,
    maintenanceAutoAppliedAfter: Optional[MillisecondDateTime] =
      Optional.Absent,
    lastMaintenanceApplied: Optional[MillisecondDateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.MaintenanceDetails = {
    import MaintenanceDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.MaintenanceDetails
      .builder()
      .optionallyWith(pendingMaintenance.map(value => value: java.lang.String))(
        _.pendingMaintenance
      )
      .optionallyWith(
        maintenanceAutoAppliedAfter.map(value =>
          MillisecondDateTime.unwrap(value): Instant
        )
      )(_.maintenanceAutoAppliedAfter)
      .optionallyWith(
        lastMaintenanceApplied.map(value =>
          MillisecondDateTime.unwrap(value): Instant
        )
      )(_.lastMaintenanceApplied)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.MaintenanceDetails.ReadOnly =
    zio.aws.ec2.model.MaintenanceDetails.wrap(buildAwsValue())
}
object MaintenanceDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.MaintenanceDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.MaintenanceDetails =
      zio.aws.ec2.model.MaintenanceDetails(
        pendingMaintenance.map(value => value),
        maintenanceAutoAppliedAfter.map(value => value),
        lastMaintenanceApplied.map(value => value)
      )
    def pendingMaintenance: Optional[String]
    def maintenanceAutoAppliedAfter: Optional[MillisecondDateTime]
    def lastMaintenanceApplied: Optional[MillisecondDateTime]
    def getPendingMaintenance: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pendingMaintenance", pendingMaintenance)
    def getMaintenanceAutoAppliedAfter
        : ZIO[Any, AwsError, MillisecondDateTime] = AwsError.unwrapOptionField(
      "maintenanceAutoAppliedAfter",
      maintenanceAutoAppliedAfter
    )
    def getLastMaintenanceApplied: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField(
        "lastMaintenanceApplied",
        lastMaintenanceApplied
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.MaintenanceDetails
  ) extends zio.aws.ec2.model.MaintenanceDetails.ReadOnly {
    override val pendingMaintenance: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.pendingMaintenance())
      .map(value => value: String)
    override val maintenanceAutoAppliedAfter: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maintenanceAutoAppliedAfter())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val lastMaintenanceApplied: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastMaintenanceApplied())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.MaintenanceDetails
  ): zio.aws.ec2.model.MaintenanceDetails.ReadOnly = new Wrapper(impl)
}
