package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait LogDestinationType {
  def unwrap: software.amazon.awssdk.services.ec2.model.LogDestinationType
}
object LogDestinationType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.LogDestinationType
  ): zio.aws.ec2.model.LogDestinationType = value match {
    case software.amazon.awssdk.services.ec2.model.LogDestinationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.LogDestinationType.CLOUD_WATCH_LOGS =>
      val r = `cloud-watch-logs`
      r
    case software.amazon.awssdk.services.ec2.model.LogDestinationType.S3 =>
      val r = s3
      r
    case software.amazon.awssdk.services.ec2.model.LogDestinationType.KINESIS_DATA_FIREHOSE =>
      val r = `kinesis-data-firehose`
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.LogDestinationType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LogDestinationType =
      software.amazon.awssdk.services.ec2.model.LogDestinationType.UNKNOWN_TO_SDK_VERSION
  }
  case object `cloud-watch-logs` extends zio.aws.ec2.model.LogDestinationType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LogDestinationType =
      software.amazon.awssdk.services.ec2.model.LogDestinationType.CLOUD_WATCH_LOGS
  }
  case object s3 extends zio.aws.ec2.model.LogDestinationType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LogDestinationType =
      software.amazon.awssdk.services.ec2.model.LogDestinationType.S3
  }
  case object `kinesis-data-firehose`
      extends zio.aws.ec2.model.LogDestinationType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LogDestinationType =
      software.amazon.awssdk.services.ec2.model.LogDestinationType.KINESIS_DATA_FIREHOSE
  }
}
