package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.Hour
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class InstanceEventWindowTimeRange(
    startWeekDay: Optional[zio.aws.ec2.model.WeekDay] = Optional.Absent,
    startHour: Optional[Hour] = Optional.Absent,
    endWeekDay: Optional[zio.aws.ec2.model.WeekDay] = Optional.Absent,
    endHour: Optional[Hour] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceEventWindowTimeRange = {
    import InstanceEventWindowTimeRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceEventWindowTimeRange
      .builder()
      .optionallyWith(startWeekDay.map(value => value.unwrap))(_.startWeekDay)
      .optionallyWith(startHour.map(value => Hour.unwrap(value): Integer))(
        _.startHour
      )
      .optionallyWith(endWeekDay.map(value => value.unwrap))(_.endWeekDay)
      .optionallyWith(endHour.map(value => Hour.unwrap(value): Integer))(
        _.endHour
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InstanceEventWindowTimeRange.ReadOnly =
    zio.aws.ec2.model.InstanceEventWindowTimeRange.wrap(buildAwsValue())
}
object InstanceEventWindowTimeRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceEventWindowTimeRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceEventWindowTimeRange =
      zio.aws.ec2.model.InstanceEventWindowTimeRange(
        startWeekDay.map(value => value),
        startHour.map(value => value),
        endWeekDay.map(value => value),
        endHour.map(value => value)
      )
    def startWeekDay: Optional[zio.aws.ec2.model.WeekDay]
    def startHour: Optional[Hour]
    def endWeekDay: Optional[zio.aws.ec2.model.WeekDay]
    def endHour: Optional[Hour]
    def getStartWeekDay: ZIO[Any, AwsError, zio.aws.ec2.model.WeekDay] =
      AwsError.unwrapOptionField("startWeekDay", startWeekDay)
    def getStartHour: ZIO[Any, AwsError, Hour] =
      AwsError.unwrapOptionField("startHour", startHour)
    def getEndWeekDay: ZIO[Any, AwsError, zio.aws.ec2.model.WeekDay] =
      AwsError.unwrapOptionField("endWeekDay", endWeekDay)
    def getEndHour: ZIO[Any, AwsError, Hour] =
      AwsError.unwrapOptionField("endHour", endHour)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceEventWindowTimeRange
  ) extends zio.aws.ec2.model.InstanceEventWindowTimeRange.ReadOnly {
    override val startWeekDay: Optional[zio.aws.ec2.model.WeekDay] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startWeekDay())
        .map(value => zio.aws.ec2.model.WeekDay.wrap(value))
    override val startHour: Optional[Hour] = zio.aws.core.internal
      .optionalFromNullable(impl.startHour())
      .map(value => zio.aws.ec2.model.primitives.Hour(value))
    override val endWeekDay: Optional[zio.aws.ec2.model.WeekDay] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endWeekDay())
        .map(value => zio.aws.ec2.model.WeekDay.wrap(value))
    override val endHour: Optional[Hour] = zio.aws.core.internal
      .optionalFromNullable(impl.endHour())
      .map(value => zio.aws.ec2.model.primitives.Hour(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceEventWindowTimeRange
  ): zio.aws.ec2.model.InstanceEventWindowTimeRange.ReadOnly = new Wrapper(impl)
}
