package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.InferenceDeviceMemorySize
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class InferenceDeviceMemoryInfo(
    sizeInMiB: Optional[InferenceDeviceMemorySize] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InferenceDeviceMemoryInfo = {
    import InferenceDeviceMemoryInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InferenceDeviceMemoryInfo
      .builder()
      .optionallyWith(
        sizeInMiB.map(value => InferenceDeviceMemorySize.unwrap(value): Integer)
      )(_.sizeInMiB)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InferenceDeviceMemoryInfo.ReadOnly =
    zio.aws.ec2.model.InferenceDeviceMemoryInfo.wrap(buildAwsValue())
}
object InferenceDeviceMemoryInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InferenceDeviceMemoryInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InferenceDeviceMemoryInfo =
      zio.aws.ec2.model.InferenceDeviceMemoryInfo(sizeInMiB.map(value => value))
    def sizeInMiB: Optional[InferenceDeviceMemorySize]
    def getSizeInMiB: ZIO[Any, AwsError, InferenceDeviceMemorySize] =
      AwsError.unwrapOptionField("sizeInMiB", sizeInMiB)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InferenceDeviceMemoryInfo
  ) extends zio.aws.ec2.model.InferenceDeviceMemoryInfo.ReadOnly {
    override val sizeInMiB: Optional[InferenceDeviceMemorySize] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sizeInMiB())
        .map(value =>
          zio.aws.ec2.model.primitives.InferenceDeviceMemorySize(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InferenceDeviceMemoryInfo
  ): zio.aws.ec2.model.InferenceDeviceMemoryInfo.ReadOnly = new Wrapper(impl)
}
