package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IamInstanceProfileSpecification(
    arn: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.IamInstanceProfileSpecification = {
    import IamInstanceProfileSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.IamInstanceProfileSpecification
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.IamInstanceProfileSpecification.ReadOnly =
    zio.aws.ec2.model.IamInstanceProfileSpecification.wrap(buildAwsValue())
}
object IamInstanceProfileSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.IamInstanceProfileSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.IamInstanceProfileSpecification =
      zio.aws.ec2.model.IamInstanceProfileSpecification(
        arn.map(value => value),
        name.map(value => value)
      )
    def arn: Optional[String]
    def name: Optional[String]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.IamInstanceProfileSpecification
  ) extends zio.aws.ec2.model.IamInstanceProfileSpecification.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.IamInstanceProfileSpecification
  ): zio.aws.ec2.model.IamInstanceProfileSpecification.ReadOnly = new Wrapper(
    impl
  )
}
