package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{Priority, ProtocolInt, ResourceArn}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class FirewallStatelessRule(
    ruleGroupArn: Optional[ResourceArn] = Optional.Absent,
    sources: Optional[Iterable[String]] = Optional.Absent,
    destinations: Optional[Iterable[String]] = Optional.Absent,
    sourcePorts: Optional[Iterable[zio.aws.ec2.model.PortRange]] =
      Optional.Absent,
    destinationPorts: Optional[Iterable[zio.aws.ec2.model.PortRange]] =
      Optional.Absent,
    protocols: Optional[Iterable[ProtocolInt]] = Optional.Absent,
    ruleAction: Optional[String] = Optional.Absent,
    priority: Optional[Priority] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.FirewallStatelessRule = {
    import FirewallStatelessRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.FirewallStatelessRule
      .builder()
      .optionallyWith(
        ruleGroupArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.ruleGroupArn)
      .optionallyWith(
        sources.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.sources)
      .optionallyWith(
        destinations.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.destinations)
      .optionallyWith(
        sourcePorts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sourcePorts)
      .optionallyWith(
        destinationPorts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.destinationPorts)
      .optionallyWith(
        protocols.map(value =>
          value.map { item =>
            ProtocolInt.unwrap(item): Integer
          }.asJavaCollection
        )
      )(_.protocols)
      .optionallyWith(ruleAction.map(value => value: java.lang.String))(
        _.ruleAction
      )
      .optionallyWith(priority.map(value => Priority.unwrap(value): Integer))(
        _.priority
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.FirewallStatelessRule.ReadOnly =
    zio.aws.ec2.model.FirewallStatelessRule.wrap(buildAwsValue())
}
object FirewallStatelessRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.FirewallStatelessRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.FirewallStatelessRule =
      zio.aws.ec2.model.FirewallStatelessRule(
        ruleGroupArn.map(value => value),
        sources.map(value => value),
        destinations.map(value => value),
        sourcePorts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        destinationPorts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        protocols.map(value => value),
        ruleAction.map(value => value),
        priority.map(value => value)
      )
    def ruleGroupArn: Optional[ResourceArn]
    def sources: Optional[List[String]]
    def destinations: Optional[List[String]]
    def sourcePorts: Optional[List[zio.aws.ec2.model.PortRange.ReadOnly]]
    def destinationPorts: Optional[List[zio.aws.ec2.model.PortRange.ReadOnly]]
    def protocols: Optional[List[ProtocolInt]]
    def ruleAction: Optional[String]
    def priority: Optional[Priority]
    def getRuleGroupArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("ruleGroupArn", ruleGroupArn)
    def getSources: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("sources", sources)
    def getDestinations: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("destinations", destinations)
    def getSourcePorts
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.PortRange.ReadOnly]] =
      AwsError.unwrapOptionField("sourcePorts", sourcePorts)
    def getDestinationPorts
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.PortRange.ReadOnly]] =
      AwsError.unwrapOptionField("destinationPorts", destinationPorts)
    def getProtocols: ZIO[Any, AwsError, List[ProtocolInt]] =
      AwsError.unwrapOptionField("protocols", protocols)
    def getRuleAction: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ruleAction", ruleAction)
    def getPriority: ZIO[Any, AwsError, Priority] =
      AwsError.unwrapOptionField("priority", priority)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.FirewallStatelessRule
  ) extends zio.aws.ec2.model.FirewallStatelessRule.ReadOnly {
    override val ruleGroupArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleGroupArn())
      .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
    override val sources: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.sources())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val destinations: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.destinations())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val sourcePorts
        : Optional[List[zio.aws.ec2.model.PortRange.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourcePorts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.PortRange.wrap(item)
          }.toList
        )
    override val destinationPorts
        : Optional[List[zio.aws.ec2.model.PortRange.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationPorts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.PortRange.wrap(item)
          }.toList
        )
    override val protocols: Optional[List[ProtocolInt]] = zio.aws.core.internal
      .optionalFromNullable(impl.protocols())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.ProtocolInt(item)
        }.toList
      )
    override val ruleAction: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleAction())
      .map(value => value: String)
    override val priority: Optional[Priority] = zio.aws.core.internal
      .optionalFromNullable(impl.priority())
      .map(value => zio.aws.ec2.model.primitives.Priority(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.FirewallStatelessRule
  ): zio.aws.ec2.model.FirewallStatelessRule.ReadOnly = new Wrapper(impl)
}
