package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait ExportTaskState {
  def unwrap: software.amazon.awssdk.services.ec2.model.ExportTaskState
}
object ExportTaskState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.ExportTaskState
  ): zio.aws.ec2.model.ExportTaskState = value match {
    case software.amazon.awssdk.services.ec2.model.ExportTaskState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.ExportTaskState.ACTIVE =>
      val r = active
      r
    case software.amazon.awssdk.services.ec2.model.ExportTaskState.CANCELLING =>
      val r = cancelling
      r
    case software.amazon.awssdk.services.ec2.model.ExportTaskState.CANCELLED =>
      val r = cancelled
      r
    case software.amazon.awssdk.services.ec2.model.ExportTaskState.COMPLETED =>
      val r = completed
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.ExportTaskState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ExportTaskState =
      software.amazon.awssdk.services.ec2.model.ExportTaskState.UNKNOWN_TO_SDK_VERSION
  }
  case object active extends zio.aws.ec2.model.ExportTaskState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ExportTaskState =
      software.amazon.awssdk.services.ec2.model.ExportTaskState.ACTIVE
  }
  case object cancelling extends zio.aws.ec2.model.ExportTaskState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ExportTaskState =
      software.amazon.awssdk.services.ec2.model.ExportTaskState.CANCELLING
  }
  case object cancelled extends zio.aws.ec2.model.ExportTaskState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ExportTaskState =
      software.amazon.awssdk.services.ec2.model.ExportTaskState.CANCELLED
  }
  case object completed extends zio.aws.ec2.model.ExportTaskState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ExportTaskState =
      software.amazon.awssdk.services.ec2.model.ExportTaskState.COMPLETED
  }
}
