package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  Port,
  IpAddress,
  ComponentRegion,
  ResourceArn,
  ComponentAccount
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Explanation(
    acl: Optional[zio.aws.ec2.model.AnalysisComponent] = Optional.Absent,
    aclRule: Optional[zio.aws.ec2.model.AnalysisAclRule] = Optional.Absent,
    address: Optional[IpAddress] = Optional.Absent,
    addresses: Optional[Iterable[IpAddress]] = Optional.Absent,
    attachedTo: Optional[zio.aws.ec2.model.AnalysisComponent] = Optional.Absent,
    availabilityZones: Optional[Iterable[String]] = Optional.Absent,
    cidrs: Optional[Iterable[String]] = Optional.Absent,
    component: Optional[zio.aws.ec2.model.AnalysisComponent] = Optional.Absent,
    customerGateway: Optional[zio.aws.ec2.model.AnalysisComponent] =
      Optional.Absent,
    destination: Optional[zio.aws.ec2.model.AnalysisComponent] =
      Optional.Absent,
    destinationVpc: Optional[zio.aws.ec2.model.AnalysisComponent] =
      Optional.Absent,
    direction: Optional[String] = Optional.Absent,
    explanationCode: Optional[String] = Optional.Absent,
    ingressRouteTable: Optional[zio.aws.ec2.model.AnalysisComponent] =
      Optional.Absent,
    internetGateway: Optional[zio.aws.ec2.model.AnalysisComponent] =
      Optional.Absent,
    loadBalancerArn: Optional[ResourceArn] = Optional.Absent,
    classicLoadBalancerListener: Optional[
      zio.aws.ec2.model.AnalysisLoadBalancerListener
    ] = Optional.Absent,
    loadBalancerListenerPort: Optional[Port] = Optional.Absent,
    loadBalancerTarget: Optional[zio.aws.ec2.model.AnalysisLoadBalancerTarget] =
      Optional.Absent,
    loadBalancerTargetGroup: Optional[zio.aws.ec2.model.AnalysisComponent] =
      Optional.Absent,
    loadBalancerTargetGroups: Optional[
      Iterable[zio.aws.ec2.model.AnalysisComponent]
    ] = Optional.Absent,
    loadBalancerTargetPort: Optional[Port] = Optional.Absent,
    elasticLoadBalancerListener: Optional[zio.aws.ec2.model.AnalysisComponent] =
      Optional.Absent,
    missingComponent: Optional[String] = Optional.Absent,
    natGateway: Optional[zio.aws.ec2.model.AnalysisComponent] = Optional.Absent,
    networkInterface: Optional[zio.aws.ec2.model.AnalysisComponent] =
      Optional.Absent,
    packetField: Optional[String] = Optional.Absent,
    vpcPeeringConnection: Optional[zio.aws.ec2.model.AnalysisComponent] =
      Optional.Absent,
    port: Optional[Port] = Optional.Absent,
    portRanges: Optional[Iterable[zio.aws.ec2.model.PortRange]] =
      Optional.Absent,
    prefixList: Optional[zio.aws.ec2.model.AnalysisComponent] = Optional.Absent,
    protocols: Optional[Iterable[String]] = Optional.Absent,
    routeTableRoute: Optional[zio.aws.ec2.model.AnalysisRouteTableRoute] =
      Optional.Absent,
    routeTable: Optional[zio.aws.ec2.model.AnalysisComponent] = Optional.Absent,
    securityGroup: Optional[zio.aws.ec2.model.AnalysisComponent] =
      Optional.Absent,
    securityGroupRule: Optional[zio.aws.ec2.model.AnalysisSecurityGroupRule] =
      Optional.Absent,
    securityGroups: Optional[Iterable[zio.aws.ec2.model.AnalysisComponent]] =
      Optional.Absent,
    sourceVpc: Optional[zio.aws.ec2.model.AnalysisComponent] = Optional.Absent,
    state: Optional[String] = Optional.Absent,
    subnet: Optional[zio.aws.ec2.model.AnalysisComponent] = Optional.Absent,
    subnetRouteTable: Optional[zio.aws.ec2.model.AnalysisComponent] =
      Optional.Absent,
    vpc: Optional[zio.aws.ec2.model.AnalysisComponent] = Optional.Absent,
    vpcEndpoint: Optional[zio.aws.ec2.model.AnalysisComponent] =
      Optional.Absent,
    vpnConnection: Optional[zio.aws.ec2.model.AnalysisComponent] =
      Optional.Absent,
    vpnGateway: Optional[zio.aws.ec2.model.AnalysisComponent] = Optional.Absent,
    transitGateway: Optional[zio.aws.ec2.model.AnalysisComponent] =
      Optional.Absent,
    transitGatewayRouteTable: Optional[zio.aws.ec2.model.AnalysisComponent] =
      Optional.Absent,
    transitGatewayRouteTableRoute: Optional[
      zio.aws.ec2.model.TransitGatewayRouteTableRoute
    ] = Optional.Absent,
    transitGatewayAttachment: Optional[zio.aws.ec2.model.AnalysisComponent] =
      Optional.Absent,
    componentAccount: Optional[ComponentAccount] = Optional.Absent,
    componentRegion: Optional[ComponentRegion] = Optional.Absent,
    firewallStatelessRule: Optional[zio.aws.ec2.model.FirewallStatelessRule] =
      Optional.Absent,
    firewallStatefulRule: Optional[zio.aws.ec2.model.FirewallStatefulRule] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.Explanation = {
    import Explanation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Explanation
      .builder()
      .optionallyWith(acl.map(value => value.buildAwsValue()))(_.acl)
      .optionallyWith(aclRule.map(value => value.buildAwsValue()))(_.aclRule)
      .optionallyWith(
        address.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.address)
      .optionallyWith(
        addresses.map(value =>
          value.map { item =>
            IpAddress.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.addresses)
      .optionallyWith(attachedTo.map(value => value.buildAwsValue()))(
        _.attachedTo
      )
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(
        cidrs.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.cidrs)
      .optionallyWith(component.map(value => value.buildAwsValue()))(
        _.component
      )
      .optionallyWith(customerGateway.map(value => value.buildAwsValue()))(
        _.customerGateway
      )
      .optionallyWith(destination.map(value => value.buildAwsValue()))(
        _.destination
      )
      .optionallyWith(destinationVpc.map(value => value.buildAwsValue()))(
        _.destinationVpc
      )
      .optionallyWith(direction.map(value => value: java.lang.String))(
        _.direction
      )
      .optionallyWith(explanationCode.map(value => value: java.lang.String))(
        _.explanationCode
      )
      .optionallyWith(ingressRouteTable.map(value => value.buildAwsValue()))(
        _.ingressRouteTable
      )
      .optionallyWith(internetGateway.map(value => value.buildAwsValue()))(
        _.internetGateway
      )
      .optionallyWith(
        loadBalancerArn.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.loadBalancerArn)
      .optionallyWith(
        classicLoadBalancerListener.map(value => value.buildAwsValue())
      )(_.classicLoadBalancerListener)
      .optionallyWith(
        loadBalancerListenerPort.map(value => Port.unwrap(value): Integer)
      )(_.loadBalancerListenerPort)
      .optionallyWith(loadBalancerTarget.map(value => value.buildAwsValue()))(
        _.loadBalancerTarget
      )
      .optionallyWith(
        loadBalancerTargetGroup.map(value => value.buildAwsValue())
      )(_.loadBalancerTargetGroup)
      .optionallyWith(
        loadBalancerTargetGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.loadBalancerTargetGroups)
      .optionallyWith(
        loadBalancerTargetPort.map(value => Port.unwrap(value): Integer)
      )(_.loadBalancerTargetPort)
      .optionallyWith(
        elasticLoadBalancerListener.map(value => value.buildAwsValue())
      )(_.elasticLoadBalancerListener)
      .optionallyWith(missingComponent.map(value => value: java.lang.String))(
        _.missingComponent
      )
      .optionallyWith(natGateway.map(value => value.buildAwsValue()))(
        _.natGateway
      )
      .optionallyWith(networkInterface.map(value => value.buildAwsValue()))(
        _.networkInterface
      )
      .optionallyWith(packetField.map(value => value: java.lang.String))(
        _.packetField
      )
      .optionallyWith(vpcPeeringConnection.map(value => value.buildAwsValue()))(
        _.vpcPeeringConnection
      )
      .optionallyWith(port.map(value => Port.unwrap(value): Integer))(_.port)
      .optionallyWith(
        portRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.portRanges)
      .optionallyWith(prefixList.map(value => value.buildAwsValue()))(
        _.prefixList
      )
      .optionallyWith(
        protocols.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.protocols)
      .optionallyWith(routeTableRoute.map(value => value.buildAwsValue()))(
        _.routeTableRoute
      )
      .optionallyWith(routeTable.map(value => value.buildAwsValue()))(
        _.routeTable
      )
      .optionallyWith(securityGroup.map(value => value.buildAwsValue()))(
        _.securityGroup
      )
      .optionallyWith(securityGroupRule.map(value => value.buildAwsValue()))(
        _.securityGroupRule
      )
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(sourceVpc.map(value => value.buildAwsValue()))(
        _.sourceVpc
      )
      .optionallyWith(state.map(value => value: java.lang.String))(_.state)
      .optionallyWith(subnet.map(value => value.buildAwsValue()))(_.subnet)
      .optionallyWith(subnetRouteTable.map(value => value.buildAwsValue()))(
        _.subnetRouteTable
      )
      .optionallyWith(vpc.map(value => value.buildAwsValue()))(_.vpc)
      .optionallyWith(vpcEndpoint.map(value => value.buildAwsValue()))(
        _.vpcEndpoint
      )
      .optionallyWith(vpnConnection.map(value => value.buildAwsValue()))(
        _.vpnConnection
      )
      .optionallyWith(vpnGateway.map(value => value.buildAwsValue()))(
        _.vpnGateway
      )
      .optionallyWith(transitGateway.map(value => value.buildAwsValue()))(
        _.transitGateway
      )
      .optionallyWith(
        transitGatewayRouteTable.map(value => value.buildAwsValue())
      )(_.transitGatewayRouteTable)
      .optionallyWith(
        transitGatewayRouteTableRoute.map(value => value.buildAwsValue())
      )(_.transitGatewayRouteTableRoute)
      .optionallyWith(
        transitGatewayAttachment.map(value => value.buildAwsValue())
      )(_.transitGatewayAttachment)
      .optionallyWith(
        componentAccount.map(value =>
          ComponentAccount.unwrap(value): java.lang.String
        )
      )(_.componentAccount)
      .optionallyWith(
        componentRegion.map(value =>
          ComponentRegion.unwrap(value): java.lang.String
        )
      )(_.componentRegion)
      .optionallyWith(
        firewallStatelessRule.map(value => value.buildAwsValue())
      )(_.firewallStatelessRule)
      .optionallyWith(firewallStatefulRule.map(value => value.buildAwsValue()))(
        _.firewallStatefulRule
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.Explanation.ReadOnly =
    zio.aws.ec2.model.Explanation.wrap(buildAwsValue())
}
object Explanation {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.Explanation] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Explanation =
      zio.aws.ec2.model.Explanation(
        acl.map(value => value.asEditable),
        aclRule.map(value => value.asEditable),
        address.map(value => value),
        addresses.map(value => value),
        attachedTo.map(value => value.asEditable),
        availabilityZones.map(value => value),
        cidrs.map(value => value),
        component.map(value => value.asEditable),
        customerGateway.map(value => value.asEditable),
        destination.map(value => value.asEditable),
        destinationVpc.map(value => value.asEditable),
        direction.map(value => value),
        explanationCode.map(value => value),
        ingressRouteTable.map(value => value.asEditable),
        internetGateway.map(value => value.asEditable),
        loadBalancerArn.map(value => value),
        classicLoadBalancerListener.map(value => value.asEditable),
        loadBalancerListenerPort.map(value => value),
        loadBalancerTarget.map(value => value.asEditable),
        loadBalancerTargetGroup.map(value => value.asEditable),
        loadBalancerTargetGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        loadBalancerTargetPort.map(value => value),
        elasticLoadBalancerListener.map(value => value.asEditable),
        missingComponent.map(value => value),
        natGateway.map(value => value.asEditable),
        networkInterface.map(value => value.asEditable),
        packetField.map(value => value),
        vpcPeeringConnection.map(value => value.asEditable),
        port.map(value => value),
        portRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        prefixList.map(value => value.asEditable),
        protocols.map(value => value),
        routeTableRoute.map(value => value.asEditable),
        routeTable.map(value => value.asEditable),
        securityGroup.map(value => value.asEditable),
        securityGroupRule.map(value => value.asEditable),
        securityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sourceVpc.map(value => value.asEditable),
        state.map(value => value),
        subnet.map(value => value.asEditable),
        subnetRouteTable.map(value => value.asEditable),
        vpc.map(value => value.asEditable),
        vpcEndpoint.map(value => value.asEditable),
        vpnConnection.map(value => value.asEditable),
        vpnGateway.map(value => value.asEditable),
        transitGateway.map(value => value.asEditable),
        transitGatewayRouteTable.map(value => value.asEditable),
        transitGatewayRouteTableRoute.map(value => value.asEditable),
        transitGatewayAttachment.map(value => value.asEditable),
        componentAccount.map(value => value),
        componentRegion.map(value => value),
        firewallStatelessRule.map(value => value.asEditable),
        firewallStatefulRule.map(value => value.asEditable)
      )
    def acl: Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def aclRule: Optional[zio.aws.ec2.model.AnalysisAclRule.ReadOnly]
    def address: Optional[IpAddress]
    def addresses: Optional[List[IpAddress]]
    def attachedTo: Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def availabilityZones: Optional[List[String]]
    def cidrs: Optional[List[String]]
    def component: Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def customerGateway: Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def destination: Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def destinationVpc: Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def direction: Optional[String]
    def explanationCode: Optional[String]
    def ingressRouteTable
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def internetGateway: Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def loadBalancerArn: Optional[ResourceArn]
    def classicLoadBalancerListener
        : Optional[zio.aws.ec2.model.AnalysisLoadBalancerListener.ReadOnly]
    def loadBalancerListenerPort: Optional[Port]
    def loadBalancerTarget
        : Optional[zio.aws.ec2.model.AnalysisLoadBalancerTarget.ReadOnly]
    def loadBalancerTargetGroup
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def loadBalancerTargetGroups
        : Optional[List[zio.aws.ec2.model.AnalysisComponent.ReadOnly]]
    def loadBalancerTargetPort: Optional[Port]
    def elasticLoadBalancerListener
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def missingComponent: Optional[String]
    def natGateway: Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def networkInterface: Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def packetField: Optional[String]
    def vpcPeeringConnection
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def port: Optional[Port]
    def portRanges: Optional[List[zio.aws.ec2.model.PortRange.ReadOnly]]
    def prefixList: Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def protocols: Optional[List[String]]
    def routeTableRoute
        : Optional[zio.aws.ec2.model.AnalysisRouteTableRoute.ReadOnly]
    def routeTable: Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def securityGroup: Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def securityGroupRule
        : Optional[zio.aws.ec2.model.AnalysisSecurityGroupRule.ReadOnly]
    def securityGroups
        : Optional[List[zio.aws.ec2.model.AnalysisComponent.ReadOnly]]
    def sourceVpc: Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def state: Optional[String]
    def subnet: Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def subnetRouteTable: Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def vpc: Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def vpcEndpoint: Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def vpnConnection: Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def vpnGateway: Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def transitGateway: Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def transitGatewayRouteTable
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def transitGatewayRouteTableRoute
        : Optional[zio.aws.ec2.model.TransitGatewayRouteTableRoute.ReadOnly]
    def transitGatewayAttachment
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def componentAccount: Optional[ComponentAccount]
    def componentRegion: Optional[ComponentRegion]
    def firewallStatelessRule
        : Optional[zio.aws.ec2.model.FirewallStatelessRule.ReadOnly]
    def firewallStatefulRule
        : Optional[zio.aws.ec2.model.FirewallStatefulRule.ReadOnly]
    def getAcl
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("acl", acl)
    def getAclRule
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisAclRule.ReadOnly] =
      AwsError.unwrapOptionField("aclRule", aclRule)
    def getAddress: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("address", address)
    def getAddresses: ZIO[Any, AwsError, List[IpAddress]] =
      AwsError.unwrapOptionField("addresses", addresses)
    def getAttachedTo
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("attachedTo", attachedTo)
    def getAvailabilityZones: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getCidrs: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("cidrs", cidrs)
    def getComponent
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("component", component)
    def getCustomerGateway
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("customerGateway", customerGateway)
    def getDestination
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("destination", destination)
    def getDestinationVpc
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("destinationVpc", destinationVpc)
    def getDirection: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("direction", direction)
    def getExplanationCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("explanationCode", explanationCode)
    def getIngressRouteTable
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("ingressRouteTable", ingressRouteTable)
    def getInternetGateway
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("internetGateway", internetGateway)
    def getLoadBalancerArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("loadBalancerArn", loadBalancerArn)
    def getClassicLoadBalancerListener: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.AnalysisLoadBalancerListener.ReadOnly
    ] = AwsError.unwrapOptionField(
      "classicLoadBalancerListener",
      classicLoadBalancerListener
    )
    def getLoadBalancerListenerPort: ZIO[Any, AwsError, Port] = AwsError
      .unwrapOptionField("loadBalancerListenerPort", loadBalancerListenerPort)
    def getLoadBalancerTarget: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.AnalysisLoadBalancerTarget.ReadOnly
    ] = AwsError.unwrapOptionField("loadBalancerTarget", loadBalancerTarget)
    def getLoadBalancerTargetGroup
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField(
        "loadBalancerTargetGroup",
        loadBalancerTargetGroup
      )
    def getLoadBalancerTargetGroups: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.AnalysisComponent.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "loadBalancerTargetGroups",
      loadBalancerTargetGroups
    )
    def getLoadBalancerTargetPort: ZIO[Any, AwsError, Port] = AwsError
      .unwrapOptionField("loadBalancerTargetPort", loadBalancerTargetPort)
    def getElasticLoadBalancerListener
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField(
        "elasticLoadBalancerListener",
        elasticLoadBalancerListener
      )
    def getMissingComponent: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("missingComponent", missingComponent)
    def getNatGateway
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("natGateway", natGateway)
    def getNetworkInterface
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("networkInterface", networkInterface)
    def getPacketField: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("packetField", packetField)
    def getVpcPeeringConnection
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("vpcPeeringConnection", vpcPeeringConnection)
    def getPort: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("port", port)
    def getPortRanges
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.PortRange.ReadOnly]] =
      AwsError.unwrapOptionField("portRanges", portRanges)
    def getPrefixList
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("prefixList", prefixList)
    def getProtocols: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("protocols", protocols)
    def getRouteTableRoute: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.AnalysisRouteTableRoute.ReadOnly
    ] = AwsError.unwrapOptionField("routeTableRoute", routeTableRoute)
    def getRouteTable
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("routeTable", routeTable)
    def getSecurityGroup
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("securityGroup", securityGroup)
    def getSecurityGroupRule: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.AnalysisSecurityGroupRule.ReadOnly
    ] = AwsError.unwrapOptionField("securityGroupRule", securityGroupRule)
    def getSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.AnalysisComponent.ReadOnly
    ]] = AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getSourceVpc
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("sourceVpc", sourceVpc)
    def getState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("state", state)
    def getSubnet
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("subnet", subnet)
    def getSubnetRouteTable
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("subnetRouteTable", subnetRouteTable)
    def getVpc
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("vpc", vpc)
    def getVpcEndpoint
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("vpcEndpoint", vpcEndpoint)
    def getVpnConnection
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("vpnConnection", vpnConnection)
    def getVpnGateway
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("vpnGateway", vpnGateway)
    def getTransitGateway
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("transitGateway", transitGateway)
    def getTransitGatewayRouteTable
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField(
        "transitGatewayRouteTable",
        transitGatewayRouteTable
      )
    def getTransitGatewayRouteTableRoute: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayRouteTableRoute.ReadOnly
    ] = AwsError.unwrapOptionField(
      "transitGatewayRouteTableRoute",
      transitGatewayRouteTableRoute
    )
    def getTransitGatewayAttachment
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField(
        "transitGatewayAttachment",
        transitGatewayAttachment
      )
    def getComponentAccount: ZIO[Any, AwsError, ComponentAccount] =
      AwsError.unwrapOptionField("componentAccount", componentAccount)
    def getComponentRegion: ZIO[Any, AwsError, ComponentRegion] =
      AwsError.unwrapOptionField("componentRegion", componentRegion)
    def getFirewallStatelessRule
        : ZIO[Any, AwsError, zio.aws.ec2.model.FirewallStatelessRule.ReadOnly] =
      AwsError.unwrapOptionField("firewallStatelessRule", firewallStatelessRule)
    def getFirewallStatefulRule
        : ZIO[Any, AwsError, zio.aws.ec2.model.FirewallStatefulRule.ReadOnly] =
      AwsError.unwrapOptionField("firewallStatefulRule", firewallStatefulRule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Explanation
  ) extends zio.aws.ec2.model.Explanation.ReadOnly {
    override val acl: Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acl())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val aclRule: Optional[zio.aws.ec2.model.AnalysisAclRule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aclRule())
        .map(value => zio.aws.ec2.model.AnalysisAclRule.wrap(value))
    override val address: Optional[IpAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.address())
      .map(value => zio.aws.ec2.model.primitives.IpAddress(value))
    override val addresses: Optional[List[IpAddress]] = zio.aws.core.internal
      .optionalFromNullable(impl.addresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.IpAddress(item)
        }.toList
      )
    override val attachedTo
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attachedTo())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val availabilityZones: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZones())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val cidrs: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.cidrs())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val component
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.component())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val customerGateway
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customerGateway())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val destination
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destination())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val destinationVpc
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationVpc())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val direction: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.direction())
      .map(value => value: String)
    override val explanationCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.explanationCode())
      .map(value => value: String)
    override val ingressRouteTable
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ingressRouteTable())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val internetGateway
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.internetGateway())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val loadBalancerArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.loadBalancerArn())
      .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
    override val classicLoadBalancerListener
        : Optional[zio.aws.ec2.model.AnalysisLoadBalancerListener.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.classicLoadBalancerListener())
        .map(value =>
          zio.aws.ec2.model.AnalysisLoadBalancerListener.wrap(value)
        )
    override val loadBalancerListenerPort: Optional[Port] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loadBalancerListenerPort())
        .map(value => zio.aws.ec2.model.primitives.Port(value))
    override val loadBalancerTarget
        : Optional[zio.aws.ec2.model.AnalysisLoadBalancerTarget.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loadBalancerTarget())
        .map(value => zio.aws.ec2.model.AnalysisLoadBalancerTarget.wrap(value))
    override val loadBalancerTargetGroup
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loadBalancerTargetGroup())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val loadBalancerTargetGroups
        : Optional[List[zio.aws.ec2.model.AnalysisComponent.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loadBalancerTargetGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.AnalysisComponent.wrap(item)
          }.toList
        )
    override val loadBalancerTargetPort: Optional[Port] = zio.aws.core.internal
      .optionalFromNullable(impl.loadBalancerTargetPort())
      .map(value => zio.aws.ec2.model.primitives.Port(value))
    override val elasticLoadBalancerListener
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.elasticLoadBalancerListener())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val missingComponent: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.missingComponent())
      .map(value => value: String)
    override val natGateway
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.natGateway())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val networkInterface
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterface())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val packetField: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.packetField())
      .map(value => value: String)
    override val vpcPeeringConnection
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcPeeringConnection())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val port: Optional[Port] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => zio.aws.ec2.model.primitives.Port(value))
    override val portRanges
        : Optional[List[zio.aws.ec2.model.PortRange.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.portRanges())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.PortRange.wrap(item)
          }.toList
        )
    override val prefixList
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.prefixList())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val protocols: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.protocols())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val routeTableRoute
        : Optional[zio.aws.ec2.model.AnalysisRouteTableRoute.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routeTableRoute())
        .map(value => zio.aws.ec2.model.AnalysisRouteTableRoute.wrap(value))
    override val routeTable
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routeTable())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val securityGroup
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroup())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val securityGroupRule
        : Optional[zio.aws.ec2.model.AnalysisSecurityGroupRule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupRule())
        .map(value => zio.aws.ec2.model.AnalysisSecurityGroupRule.wrap(value))
    override val securityGroups
        : Optional[List[zio.aws.ec2.model.AnalysisComponent.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.AnalysisComponent.wrap(item)
          }.toList
        )
    override val sourceVpc
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceVpc())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val state: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.state())
      .map(value => value: String)
    override val subnet
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subnet())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val subnetRouteTable
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subnetRouteTable())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val vpc: Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpc())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val vpcEndpoint
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcEndpoint())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val vpnConnection
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpnConnection())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val vpnGateway
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpnGateway())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val transitGateway
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGateway())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val transitGatewayRouteTable
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayRouteTable())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val transitGatewayRouteTableRoute
        : Optional[zio.aws.ec2.model.TransitGatewayRouteTableRoute.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayRouteTableRoute())
        .map(value =>
          zio.aws.ec2.model.TransitGatewayRouteTableRoute.wrap(value)
        )
    override val transitGatewayAttachment
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayAttachment())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val componentAccount: Optional[ComponentAccount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.componentAccount())
        .map(value => zio.aws.ec2.model.primitives.ComponentAccount(value))
    override val componentRegion: Optional[ComponentRegion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.componentRegion())
        .map(value => zio.aws.ec2.model.primitives.ComponentRegion(value))
    override val firewallStatelessRule
        : Optional[zio.aws.ec2.model.FirewallStatelessRule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firewallStatelessRule())
        .map(value => zio.aws.ec2.model.FirewallStatelessRule.wrap(value))
    override val firewallStatefulRule
        : Optional[zio.aws.ec2.model.FirewallStatefulRule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firewallStatefulRule())
        .map(value => zio.aws.ec2.model.FirewallStatefulRule.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Explanation
  ): zio.aws.ec2.model.Explanation.ReadOnly = new Wrapper(impl)
}
