package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.MaximumEfaInterfaces
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class EfaInfo(
    maximumEfaInterfaces: Optional[MaximumEfaInterfaces] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.EfaInfo = {
    import EfaInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EfaInfo
      .builder()
      .optionallyWith(
        maximumEfaInterfaces.map(value =>
          MaximumEfaInterfaces.unwrap(value): Integer
        )
      )(_.maximumEfaInterfaces)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.EfaInfo.ReadOnly =
    zio.aws.ec2.model.EfaInfo.wrap(buildAwsValue())
}
object EfaInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.EfaInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.EfaInfo =
      zio.aws.ec2.model.EfaInfo(maximumEfaInterfaces.map(value => value))
    def maximumEfaInterfaces: Optional[MaximumEfaInterfaces]
    def getMaximumEfaInterfaces: ZIO[Any, AwsError, MaximumEfaInterfaces] =
      AwsError.unwrapOptionField("maximumEfaInterfaces", maximumEfaInterfaces)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EfaInfo
  ) extends zio.aws.ec2.model.EfaInfo.ReadOnly {
    override val maximumEfaInterfaces: Optional[MaximumEfaInterfaces] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maximumEfaInterfaces())
        .map(value => zio.aws.ec2.model.primitives.MaximumEfaInterfaces(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EfaInfo
  ): zio.aws.ec2.model.EfaInfo.ReadOnly = new Wrapper(impl)
}
