package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{RoleId, CertificateId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisassociateEnclaveCertificateIamRoleRequest(
    certificateArn: CertificateId,
    roleArn: RoleId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisassociateEnclaveCertificateIamRoleRequest = {
    import DisassociateEnclaveCertificateIamRoleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisassociateEnclaveCertificateIamRoleRequest
      .builder()
      .certificateArn(CertificateId.unwrap(certificateArn): java.lang.String)
      .roleArn(RoleId.unwrap(roleArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DisassociateEnclaveCertificateIamRoleRequest.ReadOnly =
    zio.aws.ec2.model.DisassociateEnclaveCertificateIamRoleRequest
      .wrap(buildAwsValue())
}
object DisassociateEnclaveCertificateIamRoleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisassociateEnclaveCertificateIamRoleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DisassociateEnclaveCertificateIamRoleRequest =
      zio.aws.ec2.model
        .DisassociateEnclaveCertificateIamRoleRequest(certificateArn, roleArn)
    def certificateArn: CertificateId
    def roleArn: RoleId
    def getCertificateArn: ZIO[Any, Nothing, CertificateId] =
      ZIO.succeed(certificateArn)
    def getRoleArn: ZIO[Any, Nothing, RoleId] = ZIO.succeed(roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateEnclaveCertificateIamRoleRequest
  ) extends zio.aws.ec2.model.DisassociateEnclaveCertificateIamRoleRequest.ReadOnly {
    override val certificateArn: CertificateId =
      zio.aws.ec2.model.primitives.CertificateId(impl.certificateArn())
    override val roleArn: RoleId =
      zio.aws.ec2.model.primitives.RoleId(impl.roleArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateEnclaveCertificateIamRoleRequest
  ): zio.aws.ec2.model.DisassociateEnclaveCertificateIamRoleRequest.ReadOnly =
    new Wrapper(impl)
}
