package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  NextToken,
  DescribeIamInstanceProfileAssociationsMaxResults,
  IamInstanceProfileAssociationId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeIamInstanceProfileAssociationsRequest(
    associationIds: Optional[Iterable[IamInstanceProfileAssociationId]] =
      Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    maxResults: Optional[DescribeIamInstanceProfileAssociationsMaxResults] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsRequest = {
    import DescribeIamInstanceProfileAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsRequest
      .builder()
      .optionallyWith(
        associationIds.map(value =>
          value.map { item =>
            IamInstanceProfileAssociationId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.associationIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value =>
          DescribeIamInstanceProfileAssociationsMaxResults.unwrap(
            value
          ): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeIamInstanceProfileAssociationsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeIamInstanceProfileAssociationsRequest
      .wrap(buildAwsValue())
}
object DescribeIamInstanceProfileAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeIamInstanceProfileAssociationsRequest =
      zio.aws.ec2.model.DescribeIamInstanceProfileAssociationsRequest(
        associationIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def associationIds: Optional[List[IamInstanceProfileAssociationId]]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Optional[DescribeIamInstanceProfileAssociationsMaxResults]
    def nextToken: Optional[NextToken]
    def getAssociationIds
        : ZIO[Any, AwsError, List[IamInstanceProfileAssociationId]] =
      AwsError.unwrapOptionField("associationIds", associationIds)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults
        : ZIO[Any, AwsError, DescribeIamInstanceProfileAssociationsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsRequest
  ) extends zio.aws.ec2.model.DescribeIamInstanceProfileAssociationsRequest.ReadOnly {
    override val associationIds
        : Optional[List[IamInstanceProfileAssociationId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.IamInstanceProfileAssociationId(item)
          }.toList
        )
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults
        : Optional[DescribeIamInstanceProfileAssociationsMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives
            .DescribeIamInstanceProfileAssociationsMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsRequest
  ): zio.aws.ec2.model.DescribeIamInstanceProfileAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
