package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.FleetId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteFleetSuccessItem(
    currentFleetState: Optional[zio.aws.ec2.model.FleetStateCode] =
      Optional.Absent,
    previousFleetState: Optional[zio.aws.ec2.model.FleetStateCode] =
      Optional.Absent,
    fleetId: Optional[FleetId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteFleetSuccessItem = {
    import DeleteFleetSuccessItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteFleetSuccessItem
      .builder()
      .optionallyWith(currentFleetState.map(value => value.unwrap))(
        _.currentFleetState
      )
      .optionallyWith(previousFleetState.map(value => value.unwrap))(
        _.previousFleetState
      )
      .optionallyWith(
        fleetId.map(value => FleetId.unwrap(value): java.lang.String)
      )(_.fleetId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteFleetSuccessItem.ReadOnly =
    zio.aws.ec2.model.DeleteFleetSuccessItem.wrap(buildAwsValue())
}
object DeleteFleetSuccessItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteFleetSuccessItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteFleetSuccessItem =
      zio.aws.ec2.model.DeleteFleetSuccessItem(
        currentFleetState.map(value => value),
        previousFleetState.map(value => value),
        fleetId.map(value => value)
      )
    def currentFleetState: Optional[zio.aws.ec2.model.FleetStateCode]
    def previousFleetState: Optional[zio.aws.ec2.model.FleetStateCode]
    def fleetId: Optional[FleetId]
    def getCurrentFleetState
        : ZIO[Any, AwsError, zio.aws.ec2.model.FleetStateCode] =
      AwsError.unwrapOptionField("currentFleetState", currentFleetState)
    def getPreviousFleetState
        : ZIO[Any, AwsError, zio.aws.ec2.model.FleetStateCode] =
      AwsError.unwrapOptionField("previousFleetState", previousFleetState)
    def getFleetId: ZIO[Any, AwsError, FleetId] =
      AwsError.unwrapOptionField("fleetId", fleetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteFleetSuccessItem
  ) extends zio.aws.ec2.model.DeleteFleetSuccessItem.ReadOnly {
    override val currentFleetState: Optional[zio.aws.ec2.model.FleetStateCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentFleetState())
        .map(value => zio.aws.ec2.model.FleetStateCode.wrap(value))
    override val previousFleetState
        : Optional[zio.aws.ec2.model.FleetStateCode] = zio.aws.core.internal
      .optionalFromNullable(impl.previousFleetState())
      .map(value => zio.aws.ec2.model.FleetStateCode.wrap(value))
    override val fleetId: Optional[FleetId] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetId())
      .map(value => zio.aws.ec2.model.primitives.FleetId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteFleetSuccessItem
  ): zio.aws.ec2.model.DeleteFleetSuccessItem.ReadOnly = new Wrapper(impl)
}
