package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateVpcEndpointServiceConfigurationRequest(
    acceptanceRequired: Optional[Boolean] = Optional.Absent,
    privateDnsName: Optional[String] = Optional.Absent,
    networkLoadBalancerArns: Optional[Iterable[String]] = Optional.Absent,
    gatewayLoadBalancerArns: Optional[Iterable[String]] = Optional.Absent,
    supportedIpAddressTypes: Optional[Iterable[String]] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateVpcEndpointServiceConfigurationRequest = {
    import CreateVpcEndpointServiceConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateVpcEndpointServiceConfigurationRequest
      .builder()
      .optionallyWith(
        acceptanceRequired.map(value => value: java.lang.Boolean)
      )(_.acceptanceRequired)
      .optionallyWith(privateDnsName.map(value => value: java.lang.String))(
        _.privateDnsName
      )
      .optionallyWith(
        networkLoadBalancerArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.networkLoadBalancerArns)
      .optionallyWith(
        gatewayLoadBalancerArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.gatewayLoadBalancerArns)
      .optionallyWith(
        supportedIpAddressTypes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.supportedIpAddressTypes)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateVpcEndpointServiceConfigurationRequest.ReadOnly =
    zio.aws.ec2.model.CreateVpcEndpointServiceConfigurationRequest
      .wrap(buildAwsValue())
}
object CreateVpcEndpointServiceConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateVpcEndpointServiceConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.CreateVpcEndpointServiceConfigurationRequest =
      zio.aws.ec2.model.CreateVpcEndpointServiceConfigurationRequest(
        acceptanceRequired.map(value => value),
        privateDnsName.map(value => value),
        networkLoadBalancerArns.map(value => value),
        gatewayLoadBalancerArns.map(value => value),
        supportedIpAddressTypes.map(value => value),
        clientToken.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def acceptanceRequired: Optional[Boolean]
    def privateDnsName: Optional[String]
    def networkLoadBalancerArns: Optional[List[String]]
    def gatewayLoadBalancerArns: Optional[List[String]]
    def supportedIpAddressTypes: Optional[List[String]]
    def clientToken: Optional[String]
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getAcceptanceRequired: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("acceptanceRequired", acceptanceRequired)
    def getPrivateDnsName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateDnsName", privateDnsName)
    def getNetworkLoadBalancerArns: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("networkLoadBalancerArns", networkLoadBalancerArns)
    def getGatewayLoadBalancerArns: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("gatewayLoadBalancerArns", gatewayLoadBalancerArns)
    def getSupportedIpAddressTypes: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("supportedIpAddressTypes", supportedIpAddressTypes)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpcEndpointServiceConfigurationRequest
  ) extends zio.aws.ec2.model.CreateVpcEndpointServiceConfigurationRequest.ReadOnly {
    override val acceptanceRequired: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.acceptanceRequired())
      .map(value => value: Boolean)
    override val privateDnsName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.privateDnsName())
      .map(value => value: String)
    override val networkLoadBalancerArns: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkLoadBalancerArns())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val gatewayLoadBalancerArns: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gatewayLoadBalancerArns())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val supportedIpAddressTypes: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedIpAddressTypes())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpcEndpointServiceConfigurationRequest
  ): zio.aws.ec2.model.CreateVpcEndpointServiceConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
