package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InstanceEventWindowId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssociateInstanceEventWindowRequest(
    instanceEventWindowId: InstanceEventWindowId,
    associationTarget: zio.aws.ec2.model.InstanceEventWindowAssociationRequest
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AssociateInstanceEventWindowRequest = {
    import AssociateInstanceEventWindowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AssociateInstanceEventWindowRequest
      .builder()
      .instanceEventWindowId(
        InstanceEventWindowId.unwrap(instanceEventWindowId): java.lang.String
      )
      .associationTarget(associationTarget.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.AssociateInstanceEventWindowRequest.ReadOnly =
    zio.aws.ec2.model.AssociateInstanceEventWindowRequest.wrap(buildAwsValue())
}
object AssociateInstanceEventWindowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AssociateInstanceEventWindowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AssociateInstanceEventWindowRequest =
      zio.aws.ec2.model.AssociateInstanceEventWindowRequest(
        instanceEventWindowId,
        associationTarget.asEditable
      )
    def instanceEventWindowId: InstanceEventWindowId
    def associationTarget
        : zio.aws.ec2.model.InstanceEventWindowAssociationRequest.ReadOnly
    def getInstanceEventWindowId: ZIO[Any, Nothing, InstanceEventWindowId] =
      ZIO.succeed(instanceEventWindowId)
    def getAssociationTarget: ZIO[
      Any,
      Nothing,
      zio.aws.ec2.model.InstanceEventWindowAssociationRequest.ReadOnly
    ] = ZIO.succeed(associationTarget)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AssociateInstanceEventWindowRequest
  ) extends zio.aws.ec2.model.AssociateInstanceEventWindowRequest.ReadOnly {
    override val instanceEventWindowId: InstanceEventWindowId =
      zio.aws.ec2.model.primitives
        .InstanceEventWindowId(impl.instanceEventWindowId())
    override val associationTarget
        : zio.aws.ec2.model.InstanceEventWindowAssociationRequest.ReadOnly =
      zio.aws.ec2.model.InstanceEventWindowAssociationRequest
        .wrap(impl.associationTarget())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AssociateInstanceEventWindowRequest
  ): zio.aws.ec2.model.AssociateInstanceEventWindowRequest.ReadOnly =
    new Wrapper(impl)
}
