package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TransitGatewayAttachmentId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AcceptTransitGatewayVpcAttachmentRequest(
    transitGatewayAttachmentId: TransitGatewayAttachmentId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayVpcAttachmentRequest = {
    import AcceptTransitGatewayVpcAttachmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayVpcAttachmentRequest
      .builder()
      .transitGatewayAttachmentId(
        TransitGatewayAttachmentId.unwrap(
          transitGatewayAttachmentId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.AcceptTransitGatewayVpcAttachmentRequest.ReadOnly =
    zio.aws.ec2.model.AcceptTransitGatewayVpcAttachmentRequest
      .wrap(buildAwsValue())
}
object AcceptTransitGatewayVpcAttachmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayVpcAttachmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AcceptTransitGatewayVpcAttachmentRequest =
      zio.aws.ec2.model
        .AcceptTransitGatewayVpcAttachmentRequest(transitGatewayAttachmentId)
    def transitGatewayAttachmentId: TransitGatewayAttachmentId
    def getTransitGatewayAttachmentId
        : ZIO[Any, Nothing, TransitGatewayAttachmentId] =
      ZIO.succeed(transitGatewayAttachmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayVpcAttachmentRequest
  ) extends zio.aws.ec2.model.AcceptTransitGatewayVpcAttachmentRequest.ReadOnly {
    override val transitGatewayAttachmentId: TransitGatewayAttachmentId =
      zio.aws.ec2.model.primitives
        .TransitGatewayAttachmentId(impl.transitGatewayAttachmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayVpcAttachmentRequest
  ): zio.aws.ec2.model.AcceptTransitGatewayVpcAttachmentRequest.ReadOnly =
    new Wrapper(impl)
}
