package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait VpcPeeringConnectionStateReasonCode {
  def unwrap: software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionStateReasonCode
}
object VpcPeeringConnectionStateReasonCode {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionStateReasonCode
  ): zio.aws.ec2.model.VpcPeeringConnectionStateReasonCode = value match {
    case software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionStateReasonCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionStateReasonCode.INITIATING_REQUEST =>
      val r = `initiating-request`
      r
    case software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionStateReasonCode.PENDING_ACCEPTANCE =>
      val r = `pending-acceptance`
      r
    case software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionStateReasonCode.ACTIVE =>
      val r = active
      r
    case software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionStateReasonCode.DELETED =>
      val r = deleted
      r
    case software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionStateReasonCode.REJECTED =>
      val r = rejected
      r
    case software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionStateReasonCode.FAILED =>
      val r = failed
      r
    case software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionStateReasonCode.EXPIRED =>
      val r = expired
      r
    case software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionStateReasonCode.PROVISIONING =>
      val r = provisioning
      r
    case software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionStateReasonCode.DELETING =>
      val r = deleting
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.VpcPeeringConnectionStateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionStateReasonCode =
      software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionStateReasonCode.UNKNOWN_TO_SDK_VERSION
  }
  case object `initiating-request`
      extends zio.aws.ec2.model.VpcPeeringConnectionStateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionStateReasonCode =
      software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionStateReasonCode.INITIATING_REQUEST
  }
  case object `pending-acceptance`
      extends zio.aws.ec2.model.VpcPeeringConnectionStateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionStateReasonCode =
      software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionStateReasonCode.PENDING_ACCEPTANCE
  }
  case object active
      extends zio.aws.ec2.model.VpcPeeringConnectionStateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionStateReasonCode =
      software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionStateReasonCode.ACTIVE
  }
  case object deleted
      extends zio.aws.ec2.model.VpcPeeringConnectionStateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionStateReasonCode =
      software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionStateReasonCode.DELETED
  }
  case object rejected
      extends zio.aws.ec2.model.VpcPeeringConnectionStateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionStateReasonCode =
      software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionStateReasonCode.REJECTED
  }
  case object failed
      extends zio.aws.ec2.model.VpcPeeringConnectionStateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionStateReasonCode =
      software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionStateReasonCode.FAILED
  }
  case object expired
      extends zio.aws.ec2.model.VpcPeeringConnectionStateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionStateReasonCode =
      software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionStateReasonCode.EXPIRED
  }
  case object provisioning
      extends zio.aws.ec2.model.VpcPeeringConnectionStateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionStateReasonCode =
      software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionStateReasonCode.PROVISIONING
  }
  case object deleting
      extends zio.aws.ec2.model.VpcPeeringConnectionStateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionStateReasonCode =
      software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionStateReasonCode.DELETING
  }
}
