package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VerifiedAccessTrustProviderCondensed(
    verifiedAccessTrustProviderId: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    trustProviderType: Optional[zio.aws.ec2.model.TrustProviderType] =
      Optional.Absent,
    userTrustProviderType: Optional[zio.aws.ec2.model.UserTrustProviderType] =
      Optional.Absent,
    deviceTrustProviderType: Optional[
      zio.aws.ec2.model.DeviceTrustProviderType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VerifiedAccessTrustProviderCondensed = {
    import VerifiedAccessTrustProviderCondensed.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VerifiedAccessTrustProviderCondensed
      .builder()
      .optionallyWith(
        verifiedAccessTrustProviderId.map(value => value: java.lang.String)
      )(_.verifiedAccessTrustProviderId)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(trustProviderType.map(value => value.unwrap))(
        _.trustProviderType
      )
      .optionallyWith(userTrustProviderType.map(value => value.unwrap))(
        _.userTrustProviderType
      )
      .optionallyWith(deviceTrustProviderType.map(value => value.unwrap))(
        _.deviceTrustProviderType
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.VerifiedAccessTrustProviderCondensed.ReadOnly =
    zio.aws.ec2.model.VerifiedAccessTrustProviderCondensed.wrap(buildAwsValue())
}
object VerifiedAccessTrustProviderCondensed {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VerifiedAccessTrustProviderCondensed
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VerifiedAccessTrustProviderCondensed =
      zio.aws.ec2.model.VerifiedAccessTrustProviderCondensed(
        verifiedAccessTrustProviderId.map(value => value),
        description.map(value => value),
        trustProviderType.map(value => value),
        userTrustProviderType.map(value => value),
        deviceTrustProviderType.map(value => value)
      )
    def verifiedAccessTrustProviderId: Optional[String]
    def description: Optional[String]
    def trustProviderType: Optional[zio.aws.ec2.model.TrustProviderType]
    def userTrustProviderType: Optional[zio.aws.ec2.model.UserTrustProviderType]
    def deviceTrustProviderType
        : Optional[zio.aws.ec2.model.DeviceTrustProviderType]
    def getVerifiedAccessTrustProviderId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "verifiedAccessTrustProviderId",
        verifiedAccessTrustProviderId
      )
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getTrustProviderType
        : ZIO[Any, AwsError, zio.aws.ec2.model.TrustProviderType] =
      AwsError.unwrapOptionField("trustProviderType", trustProviderType)
    def getUserTrustProviderType
        : ZIO[Any, AwsError, zio.aws.ec2.model.UserTrustProviderType] =
      AwsError.unwrapOptionField("userTrustProviderType", userTrustProviderType)
    def getDeviceTrustProviderType
        : ZIO[Any, AwsError, zio.aws.ec2.model.DeviceTrustProviderType] =
      AwsError.unwrapOptionField(
        "deviceTrustProviderType",
        deviceTrustProviderType
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VerifiedAccessTrustProviderCondensed
  ) extends zio.aws.ec2.model.VerifiedAccessTrustProviderCondensed.ReadOnly {
    override val verifiedAccessTrustProviderId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verifiedAccessTrustProviderId())
        .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val trustProviderType
        : Optional[zio.aws.ec2.model.TrustProviderType] = zio.aws.core.internal
      .optionalFromNullable(impl.trustProviderType())
      .map(value => zio.aws.ec2.model.TrustProviderType.wrap(value))
    override val userTrustProviderType
        : Optional[zio.aws.ec2.model.UserTrustProviderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userTrustProviderType())
        .map(value => zio.aws.ec2.model.UserTrustProviderType.wrap(value))
    override val deviceTrustProviderType
        : Optional[zio.aws.ec2.model.DeviceTrustProviderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceTrustProviderType())
        .map(value => zio.aws.ec2.model.DeviceTrustProviderType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VerifiedAccessTrustProviderCondensed
  ): zio.aws.ec2.model.VerifiedAccessTrustProviderCondensed.ReadOnly =
    new Wrapper(impl)
}
