package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait TrustProviderType {
  def unwrap: software.amazon.awssdk.services.ec2.model.TrustProviderType
}
object TrustProviderType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.TrustProviderType
  ): zio.aws.ec2.model.TrustProviderType = value match {
    case software.amazon.awssdk.services.ec2.model.TrustProviderType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.TrustProviderType.USER =>
      val r = user
      r
    case software.amazon.awssdk.services.ec2.model.TrustProviderType.DEVICE =>
      val r = device
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.TrustProviderType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TrustProviderType =
      software.amazon.awssdk.services.ec2.model.TrustProviderType.UNKNOWN_TO_SDK_VERSION
  }
  case object user extends zio.aws.ec2.model.TrustProviderType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TrustProviderType =
      software.amazon.awssdk.services.ec2.model.TrustProviderType.USER
  }
  case object device extends zio.aws.ec2.model.TrustProviderType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TrustProviderType =
      software.amazon.awssdk.services.ec2.model.TrustProviderType.DEVICE
  }
}
