package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  TransitGatewayRouteTableId,
  TransitGatewayAttachmentId,
  DateTime,
  TransitGatewayId,
  TransitGatewayRouteTableAnnouncementId
}
import scala.jdk.CollectionConverters._
final case class TransitGatewayRouteTableAnnouncement(
    transitGatewayRouteTableAnnouncementId: Optional[
      TransitGatewayRouteTableAnnouncementId
    ] = Optional.Absent,
    transitGatewayId: Optional[TransitGatewayId] = Optional.Absent,
    coreNetworkId: Optional[String] = Optional.Absent,
    peerTransitGatewayId: Optional[TransitGatewayId] = Optional.Absent,
    peerCoreNetworkId: Optional[String] = Optional.Absent,
    peeringAttachmentId: Optional[TransitGatewayAttachmentId] = Optional.Absent,
    announcementDirection: Optional[
      zio.aws.ec2.model.TransitGatewayRouteTableAnnouncementDirection
    ] = Optional.Absent,
    transitGatewayRouteTableId: Optional[TransitGatewayRouteTableId] =
      Optional.Absent,
    state: Optional[
      zio.aws.ec2.model.TransitGatewayRouteTableAnnouncementState
    ] = Optional.Absent,
    creationTime: Optional[DateTime] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTableAnnouncement = {
    import TransitGatewayRouteTableAnnouncement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTableAnnouncement
      .builder()
      .optionallyWith(
        transitGatewayRouteTableAnnouncementId.map(value =>
          TransitGatewayRouteTableAnnouncementId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayRouteTableAnnouncementId)
      .optionallyWith(
        transitGatewayId.map(value =>
          TransitGatewayId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayId)
      .optionallyWith(coreNetworkId.map(value => value: java.lang.String))(
        _.coreNetworkId
      )
      .optionallyWith(
        peerTransitGatewayId.map(value =>
          TransitGatewayId.unwrap(value): java.lang.String
        )
      )(_.peerTransitGatewayId)
      .optionallyWith(peerCoreNetworkId.map(value => value: java.lang.String))(
        _.peerCoreNetworkId
      )
      .optionallyWith(
        peeringAttachmentId.map(value =>
          TransitGatewayAttachmentId.unwrap(value): java.lang.String
        )
      )(_.peeringAttachmentId)
      .optionallyWith(announcementDirection.map(value => value.unwrap))(
        _.announcementDirection
      )
      .optionallyWith(
        transitGatewayRouteTableId.map(value =>
          TransitGatewayRouteTableId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayRouteTableId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        creationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.TransitGatewayRouteTableAnnouncement.ReadOnly =
    zio.aws.ec2.model.TransitGatewayRouteTableAnnouncement.wrap(buildAwsValue())
}
object TransitGatewayRouteTableAnnouncement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTableAnnouncement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayRouteTableAnnouncement =
      zio.aws.ec2.model.TransitGatewayRouteTableAnnouncement(
        transitGatewayRouteTableAnnouncementId.map(value => value),
        transitGatewayId.map(value => value),
        coreNetworkId.map(value => value),
        peerTransitGatewayId.map(value => value),
        peerCoreNetworkId.map(value => value),
        peeringAttachmentId.map(value => value),
        announcementDirection.map(value => value),
        transitGatewayRouteTableId.map(value => value),
        state.map(value => value),
        creationTime.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def transitGatewayRouteTableAnnouncementId
        : Optional[TransitGatewayRouteTableAnnouncementId]
    def transitGatewayId: Optional[TransitGatewayId]
    def coreNetworkId: Optional[String]
    def peerTransitGatewayId: Optional[TransitGatewayId]
    def peerCoreNetworkId: Optional[String]
    def peeringAttachmentId: Optional[TransitGatewayAttachmentId]
    def announcementDirection: Optional[
      zio.aws.ec2.model.TransitGatewayRouteTableAnnouncementDirection
    ]
    def transitGatewayRouteTableId: Optional[TransitGatewayRouteTableId]
    def state
        : Optional[zio.aws.ec2.model.TransitGatewayRouteTableAnnouncementState]
    def creationTime: Optional[DateTime]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getTransitGatewayRouteTableAnnouncementId
        : ZIO[Any, AwsError, TransitGatewayRouteTableAnnouncementId] =
      AwsError.unwrapOptionField(
        "transitGatewayRouteTableAnnouncementId",
        transitGatewayRouteTableAnnouncementId
      )
    def getTransitGatewayId: ZIO[Any, AwsError, TransitGatewayId] =
      AwsError.unwrapOptionField("transitGatewayId", transitGatewayId)
    def getCoreNetworkId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("coreNetworkId", coreNetworkId)
    def getPeerTransitGatewayId: ZIO[Any, AwsError, TransitGatewayId] =
      AwsError.unwrapOptionField("peerTransitGatewayId", peerTransitGatewayId)
    def getPeerCoreNetworkId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("peerCoreNetworkId", peerCoreNetworkId)
    def getPeeringAttachmentId: ZIO[Any, AwsError, TransitGatewayAttachmentId] =
      AwsError.unwrapOptionField("peeringAttachmentId", peeringAttachmentId)
    def getAnnouncementDirection: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayRouteTableAnnouncementDirection
    ] =
      AwsError.unwrapOptionField("announcementDirection", announcementDirection)
    def getTransitGatewayRouteTableId
        : ZIO[Any, AwsError, TransitGatewayRouteTableId] =
      AwsError.unwrapOptionField(
        "transitGatewayRouteTableId",
        transitGatewayRouteTableId
      )
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayRouteTableAnnouncementState
    ] = AwsError.unwrapOptionField("state", state)
    def getCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTableAnnouncement
  ) extends zio.aws.ec2.model.TransitGatewayRouteTableAnnouncement.ReadOnly {
    override val transitGatewayRouteTableAnnouncementId
        : Optional[TransitGatewayRouteTableAnnouncementId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayRouteTableAnnouncementId())
        .map(value =>
          zio.aws.ec2.model.primitives
            .TransitGatewayRouteTableAnnouncementId(value)
        )
    override val transitGatewayId: Optional[TransitGatewayId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayId())
        .map(value => zio.aws.ec2.model.primitives.TransitGatewayId(value))
    override val coreNetworkId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.coreNetworkId())
      .map(value => value: String)
    override val peerTransitGatewayId: Optional[TransitGatewayId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.peerTransitGatewayId())
        .map(value => zio.aws.ec2.model.primitives.TransitGatewayId(value))
    override val peerCoreNetworkId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.peerCoreNetworkId())
      .map(value => value: String)
    override val peeringAttachmentId: Optional[TransitGatewayAttachmentId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.peeringAttachmentId())
        .map(value =>
          zio.aws.ec2.model.primitives.TransitGatewayAttachmentId(value)
        )
    override val announcementDirection: Optional[
      zio.aws.ec2.model.TransitGatewayRouteTableAnnouncementDirection
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.announcementDirection())
      .map(value =>
        zio.aws.ec2.model.TransitGatewayRouteTableAnnouncementDirection
          .wrap(value)
      )
    override val transitGatewayRouteTableId
        : Optional[TransitGatewayRouteTableId] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayRouteTableId())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayRouteTableId(value)
      )
    override val state: Optional[
      zio.aws.ec2.model.TransitGatewayRouteTableAnnouncementState
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.state())
      .map(value =>
        zio.aws.ec2.model.TransitGatewayRouteTableAnnouncementState.wrap(value)
      )
    override val creationTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTableAnnouncement
  ): zio.aws.ec2.model.TransitGatewayRouteTableAnnouncement.ReadOnly =
    new Wrapper(impl)
}
