package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  TransitGatewayRouteTableAnnouncementId,
  PrefixListResourceId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TransitGatewayRoute(
    destinationCidrBlock: Optional[String] = Optional.Absent,
    prefixListId: Optional[PrefixListResourceId] = Optional.Absent,
    transitGatewayRouteTableAnnouncementId: Optional[
      TransitGatewayRouteTableAnnouncementId
    ] = Optional.Absent,
    transitGatewayAttachments: Optional[
      Iterable[zio.aws.ec2.model.TransitGatewayRouteAttachment]
    ] = Optional.Absent,
    `type`: Optional[zio.aws.ec2.model.TransitGatewayRouteType] =
      Optional.Absent,
    state: Optional[zio.aws.ec2.model.TransitGatewayRouteState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayRoute = {
    import TransitGatewayRoute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayRoute
      .builder()
      .optionallyWith(
        destinationCidrBlock.map(value => value: java.lang.String)
      )(_.destinationCidrBlock)
      .optionallyWith(
        prefixListId.map(value =>
          PrefixListResourceId.unwrap(value): java.lang.String
        )
      )(_.prefixListId)
      .optionallyWith(
        transitGatewayRouteTableAnnouncementId.map(value =>
          TransitGatewayRouteTableAnnouncementId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayRouteTableAnnouncementId)
      .optionallyWith(
        transitGatewayAttachments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.transitGatewayAttachments)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TransitGatewayRoute.ReadOnly =
    zio.aws.ec2.model.TransitGatewayRoute.wrap(buildAwsValue())
}
object TransitGatewayRoute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayRoute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayRoute =
      zio.aws.ec2.model.TransitGatewayRoute(
        destinationCidrBlock.map(value => value),
        prefixListId.map(value => value),
        transitGatewayRouteTableAnnouncementId.map(value => value),
        transitGatewayAttachments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        `type`.map(value => value),
        state.map(value => value)
      )
    def destinationCidrBlock: Optional[String]
    def prefixListId: Optional[PrefixListResourceId]
    def transitGatewayRouteTableAnnouncementId
        : Optional[TransitGatewayRouteTableAnnouncementId]
    def transitGatewayAttachments: Optional[
      List[zio.aws.ec2.model.TransitGatewayRouteAttachment.ReadOnly]
    ]
    def `type`: Optional[zio.aws.ec2.model.TransitGatewayRouteType]
    def state: Optional[zio.aws.ec2.model.TransitGatewayRouteState]
    def getDestinationCidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("destinationCidrBlock", destinationCidrBlock)
    def getPrefixListId: ZIO[Any, AwsError, PrefixListResourceId] =
      AwsError.unwrapOptionField("prefixListId", prefixListId)
    def getTransitGatewayRouteTableAnnouncementId
        : ZIO[Any, AwsError, TransitGatewayRouteTableAnnouncementId] =
      AwsError.unwrapOptionField(
        "transitGatewayRouteTableAnnouncementId",
        transitGatewayRouteTableAnnouncementId
      )
    def getTransitGatewayAttachments: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TransitGatewayRouteAttachment.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "transitGatewayAttachments",
      transitGatewayAttachments
    )
    def getType: ZIO[Any, AwsError, zio.aws.ec2.model.TransitGatewayRouteType] =
      AwsError.unwrapOptionField("type", `type`)
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.TransitGatewayRouteState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayRoute
  ) extends zio.aws.ec2.model.TransitGatewayRoute.ReadOnly {
    override val destinationCidrBlock: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationCidrBlock())
      .map(value => value: String)
    override val prefixListId: Optional[PrefixListResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.prefixListId())
        .map(value => zio.aws.ec2.model.primitives.PrefixListResourceId(value))
    override val transitGatewayRouteTableAnnouncementId
        : Optional[TransitGatewayRouteTableAnnouncementId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayRouteTableAnnouncementId())
        .map(value =>
          zio.aws.ec2.model.primitives
            .TransitGatewayRouteTableAnnouncementId(value)
        )
    override val transitGatewayAttachments: Optional[
      List[zio.aws.ec2.model.TransitGatewayRouteAttachment.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayAttachments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TransitGatewayRouteAttachment.wrap(item)
        }.toList
      )
    override val `type`: Optional[zio.aws.ec2.model.TransitGatewayRouteType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.ec2.model.TransitGatewayRouteType.wrap(value))
    override val state: Optional[zio.aws.ec2.model.TransitGatewayRouteState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.TransitGatewayRouteState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayRoute
  ): zio.aws.ec2.model.TransitGatewayRoute.ReadOnly = new Wrapper(impl)
}
