package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ClientVpnEndpointId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TerminateClientVpnConnectionsRequest(
    clientVpnEndpointId: ClientVpnEndpointId,
    connectionId: Optional[String] = Optional.Absent,
    username: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TerminateClientVpnConnectionsRequest = {
    import TerminateClientVpnConnectionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TerminateClientVpnConnectionsRequest
      .builder()
      .clientVpnEndpointId(
        ClientVpnEndpointId.unwrap(clientVpnEndpointId): java.lang.String
      )
      .optionallyWith(connectionId.map(value => value: java.lang.String))(
        _.connectionId
      )
      .optionallyWith(username.map(value => value: java.lang.String))(
        _.username
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.TerminateClientVpnConnectionsRequest.ReadOnly =
    zio.aws.ec2.model.TerminateClientVpnConnectionsRequest.wrap(buildAwsValue())
}
object TerminateClientVpnConnectionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TerminateClientVpnConnectionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TerminateClientVpnConnectionsRequest =
      zio.aws.ec2.model.TerminateClientVpnConnectionsRequest(
        clientVpnEndpointId,
        connectionId.map(value => value),
        username.map(value => value)
      )
    def clientVpnEndpointId: ClientVpnEndpointId
    def connectionId: Optional[String]
    def username: Optional[String]
    def getClientVpnEndpointId: ZIO[Any, Nothing, ClientVpnEndpointId] =
      ZIO.succeed(clientVpnEndpointId)
    def getConnectionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("connectionId", connectionId)
    def getUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("username", username)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TerminateClientVpnConnectionsRequest
  ) extends zio.aws.ec2.model.TerminateClientVpnConnectionsRequest.ReadOnly {
    override val clientVpnEndpointId: ClientVpnEndpointId =
      zio.aws.ec2.model.primitives
        .ClientVpnEndpointId(impl.clientVpnEndpointId())
    override val connectionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionId())
      .map(value => value: String)
    override val username: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.username())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TerminateClientVpnConnectionsRequest
  ): zio.aws.ec2.model.TerminateClientVpnConnectionsRequest.ReadOnly =
    new Wrapper(impl)
}
